--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBootOptionPowerOnDelay1 = {}

---@class BiosIpmiCmds.GetBootOptionPowerOnDelay1Req
---@field OtherSelector string
local TGetBootOptionPowerOnDelay1Req = {}
TGetBootOptionPowerOnDelay1Req.__index = TGetBootOptionPowerOnDelay1Req
TGetBootOptionPowerOnDelay1Req.group = {}

local function TGetBootOptionPowerOnDelay1Req_from_obj(obj)
    return setmetatable(obj, TGetBootOptionPowerOnDelay1Req)
end

function TGetBootOptionPowerOnDelay1Req.new(OtherSelector)
    return TGetBootOptionPowerOnDelay1Req_from_obj({OtherSelector = OtherSelector})
end
---@param obj BiosIpmiCmds.GetBootOptionPowerOnDelay1Req
function TGetBootOptionPowerOnDelay1Req:init_from_obj(obj)
    self.OtherSelector = obj.OtherSelector
end

function TGetBootOptionPowerOnDelay1Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOptionPowerOnDelay1Req.group)
end

TGetBootOptionPowerOnDelay1Req.from_obj = TGetBootOptionPowerOnDelay1Req_from_obj

TGetBootOptionPowerOnDelay1Req.proto_property = {'OtherSelector'}

TGetBootOptionPowerOnDelay1Req.default = {''}

TGetBootOptionPowerOnDelay1Req.struct = {{name = 'OtherSelector', is_array = false, struct = nil}}

function TGetBootOptionPowerOnDelay1Req:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OtherSelector', self.OtherSelector, 'string', false, errs, need_convert)

    TGetBootOptionPowerOnDelay1Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOptionPowerOnDelay1Req.proto_property, errs, need_convert)
    return self
end

function TGetBootOptionPowerOnDelay1Req:unpack(_)
    return self.OtherSelector
end

GetBootOptionPowerOnDelay1.GetBootOptionPowerOnDelay1Req = TGetBootOptionPowerOnDelay1Req

---@class BiosIpmiCmds.GetBootOptionPowerOnDelay1Rsp
---@field CompletionCode integer
---@field ParameterVersion integer
---@field BootOptionSelector integer
---@field OtherData string
local TGetBootOptionPowerOnDelay1Rsp = {}
TGetBootOptionPowerOnDelay1Rsp.__index = TGetBootOptionPowerOnDelay1Rsp
TGetBootOptionPowerOnDelay1Rsp.group = {}

local function TGetBootOptionPowerOnDelay1Rsp_from_obj(obj)
    return setmetatable(obj, TGetBootOptionPowerOnDelay1Rsp)
end

function TGetBootOptionPowerOnDelay1Rsp.new(CompletionCode, ParameterVersion, BootOptionSelector, OtherData)
    return TGetBootOptionPowerOnDelay1Rsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterVersion = ParameterVersion,
        BootOptionSelector = BootOptionSelector,
        OtherData = OtherData
    })
end
---@param obj BiosIpmiCmds.GetBootOptionPowerOnDelay1Rsp
function TGetBootOptionPowerOnDelay1Rsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterVersion = obj.ParameterVersion
    self.BootOptionSelector = obj.BootOptionSelector
    self.OtherData = obj.OtherData
end

function TGetBootOptionPowerOnDelay1Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOptionPowerOnDelay1Rsp.group)
end

TGetBootOptionPowerOnDelay1Rsp.from_obj = TGetBootOptionPowerOnDelay1Rsp_from_obj

TGetBootOptionPowerOnDelay1Rsp.proto_property = {
    'CompletionCode', 'ParameterVersion', 'BootOptionSelector', 'OtherData'
}

TGetBootOptionPowerOnDelay1Rsp.default = {0, 0, 0, ''}

TGetBootOptionPowerOnDelay1Rsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterVersion', is_array = false, struct = nil},
    {name = 'BootOptionSelector', is_array = false, struct = nil}, {name = 'OtherData', is_array = false, struct = nil}
}

function TGetBootOptionPowerOnDelay1Rsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterVersion', self.ParameterVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BootOptionSelector', self.BootOptionSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OtherData', self.OtherData, 'string', false, errs, need_convert)

    TGetBootOptionPowerOnDelay1Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOptionPowerOnDelay1Rsp.proto_property, errs, need_convert)
    return self
end

function TGetBootOptionPowerOnDelay1Rsp:unpack(_)
    return self.CompletionCode, self.ParameterVersion, self.BootOptionSelector, self.OtherData
end

GetBootOptionPowerOnDelay1.GetBootOptionPowerOnDelay1Rsp = TGetBootOptionPowerOnDelay1Rsp

return GetBootOptionPowerOnDelay1
