--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBiosGoldValid = {}

---@class BiosIpmiCmds.GetBiosGoldValidReq
---@field Reserved string
local TGetBiosGoldValidReq = {}
TGetBiosGoldValidReq.__index = TGetBiosGoldValidReq
TGetBiosGoldValidReq.group = {}

local function TGetBiosGoldValidReq_from_obj(obj)
    return setmetatable(obj, TGetBiosGoldValidReq)
end

function TGetBiosGoldValidReq.new(Reserved)
    return TGetBiosGoldValidReq_from_obj({Reserved = Reserved})
end
---@param obj BiosIpmiCmds.GetBiosGoldValidReq
function TGetBiosGoldValidReq:init_from_obj(obj)
    self.Reserved = obj.Reserved
end

function TGetBiosGoldValidReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosGoldValidReq.group)
end

TGetBiosGoldValidReq.from_obj = TGetBiosGoldValidReq_from_obj

TGetBiosGoldValidReq.proto_property = {'Reserved'}

TGetBiosGoldValidReq.default = {''}

TGetBiosGoldValidReq.struct = {{name = 'Reserved', is_array = false, struct = nil}}

function TGetBiosGoldValidReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reserved', self.Reserved, 'string', false, errs, need_convert)

    TGetBiosGoldValidReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosGoldValidReq.proto_property, errs, need_convert)
    return self
end

function TGetBiosGoldValidReq:unpack(_)
    return self.Reserved
end

GetBiosGoldValid.GetBiosGoldValidReq = TGetBiosGoldValidReq

---@class BiosIpmiCmds.GetBiosGoldValidRsp
---@field CompletionCode integer
---@field Reserved integer
---@field ConfigurationParameter string
local TGetBiosGoldValidRsp = {}
TGetBiosGoldValidRsp.__index = TGetBiosGoldValidRsp
TGetBiosGoldValidRsp.group = {}

local function TGetBiosGoldValidRsp_from_obj(obj)
    return setmetatable(obj, TGetBiosGoldValidRsp)
end

function TGetBiosGoldValidRsp.new(CompletionCode, Reserved, ConfigurationParameter)
    return TGetBiosGoldValidRsp_from_obj({
        CompletionCode = CompletionCode,
        Reserved = Reserved,
        ConfigurationParameter = ConfigurationParameter
    })
end
---@param obj BiosIpmiCmds.GetBiosGoldValidRsp
function TGetBiosGoldValidRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Reserved = obj.Reserved
    self.ConfigurationParameter = obj.ConfigurationParameter
end

function TGetBiosGoldValidRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosGoldValidRsp.group)
end

TGetBiosGoldValidRsp.from_obj = TGetBiosGoldValidRsp_from_obj

TGetBiosGoldValidRsp.proto_property = {'CompletionCode', 'Reserved', 'ConfigurationParameter'}

TGetBiosGoldValidRsp.default = {0, 0, ''}

TGetBiosGoldValidRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'ConfigurationParameter', is_array = false, struct = nil}
}

function TGetBiosGoldValidRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigurationParameter', self.ConfigurationParameter, 'string', false, errs,
        need_convert)

    TGetBiosGoldValidRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosGoldValidRsp.proto_property, errs, need_convert)
    return self
end

function TGetBiosGoldValidRsp:unpack(_)
    return self.CompletionCode, self.Reserved, self.ConfigurationParameter
end

GetBiosGoldValid.GetBiosGoldValidRsp = TGetBiosGoldValidRsp

return GetBiosGoldValid
