--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBiosBootInfo = {}

---@class BiosIpmiCmds.GetBiosBootInfoReq
---@field ManufactureId integer
---@field BiosId integer
---@field PropOption integer
local TGetBiosBootInfoReq = {}
TGetBiosBootInfoReq.__index = TGetBiosBootInfoReq
TGetBiosBootInfoReq.group = {}

local function TGetBiosBootInfoReq_from_obj(obj)
    return setmetatable(obj, TGetBiosBootInfoReq)
end

function TGetBiosBootInfoReq.new(ManufactureId, BiosId, PropOption)
    return TGetBiosBootInfoReq_from_obj({ManufactureId = ManufactureId, BiosId = BiosId, PropOption = PropOption})
end
---@param obj BiosIpmiCmds.GetBiosBootInfoReq
function TGetBiosBootInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.PropOption = obj.PropOption
end

function TGetBiosBootInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosBootInfoReq.group)
end

TGetBiosBootInfoReq.from_obj = TGetBiosBootInfoReq_from_obj

TGetBiosBootInfoReq.proto_property = {'ManufactureId', 'BiosId', 'PropOption'}

TGetBiosBootInfoReq.default = {0, 0, 0}

TGetBiosBootInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'PropOption', is_array = false, struct = nil}
}

function TGetBiosBootInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PropOption', self.PropOption, 'uint8', false, errs, need_convert)

    TGetBiosBootInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosBootInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetBiosBootInfoReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.PropOption
end

GetBiosBootInfo.GetBiosBootInfoReq = TGetBiosBootInfoReq

---@class BiosIpmiCmds.GetBiosBootInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field PropLen integer
---@field PropValue string
local TGetBiosBootInfoRsp = {}
TGetBiosBootInfoRsp.__index = TGetBiosBootInfoRsp
TGetBiosBootInfoRsp.group = {}

local function TGetBiosBootInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetBiosBootInfoRsp)
end

function TGetBiosBootInfoRsp.new(CompletionCode, ManufactureId, PropLen, PropValue)
    return TGetBiosBootInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        PropLen = PropLen,
        PropValue = PropValue
    })
end
---@param obj BiosIpmiCmds.GetBiosBootInfoRsp
function TGetBiosBootInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.PropLen = obj.PropLen
    self.PropValue = obj.PropValue
end

function TGetBiosBootInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosBootInfoRsp.group)
end

TGetBiosBootInfoRsp.from_obj = TGetBiosBootInfoRsp_from_obj

TGetBiosBootInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'PropLen', 'PropValue'}

TGetBiosBootInfoRsp.default = {0, 0, 0, ''}

TGetBiosBootInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'PropLen', is_array = false, struct = nil}, {name = 'PropValue', is_array = false, struct = nil}
}

function TGetBiosBootInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PropLen', self.PropLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PropValue', self.PropValue, 'string', false, errs, need_convert)

    TGetBiosBootInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosBootInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetBiosBootInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.PropLen, self.PropValue
end

GetBiosBootInfo.GetBiosBootInfoRsp = TGetBiosBootInfoRsp

return GetBiosBootInfo
