--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local AddBiosLogEntry = {}

---@class BiosIpmiCmds.AddBiosLogEntryReq
---@field ManufactureId integer
---@field EventType integer
---@field Log string
local TAddBiosLogEntryReq = {}
TAddBiosLogEntryReq.__index = TAddBiosLogEntryReq
TAddBiosLogEntryReq.group = {}

local function TAddBiosLogEntryReq_from_obj(obj)
    return setmetatable(obj, TAddBiosLogEntryReq)
end

function TAddBiosLogEntryReq.new(ManufactureId, EventType, Log)
    return TAddBiosLogEntryReq_from_obj({ManufactureId = ManufactureId, EventType = EventType, Log = Log})
end
---@param obj BiosIpmiCmds.AddBiosLogEntryReq
function TAddBiosLogEntryReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventType = obj.EventType
    self.Log = obj.Log
end

function TAddBiosLogEntryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddBiosLogEntryReq.group)
end

TAddBiosLogEntryReq.from_obj = TAddBiosLogEntryReq_from_obj

TAddBiosLogEntryReq.proto_property = {'ManufactureId', 'EventType', 'Log'}

TAddBiosLogEntryReq.default = {0, 0, ''}

TAddBiosLogEntryReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil},
    {name = 'Log', is_array = false, struct = nil}
}

function TAddBiosLogEntryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Log', self.Log, 'string', false, errs, need_convert)

    TAddBiosLogEntryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddBiosLogEntryReq.proto_property, errs, need_convert)
    return self
end

function TAddBiosLogEntryReq:unpack(_)
    return self.ManufactureId, self.EventType, self.Log
end

AddBiosLogEntry.AddBiosLogEntryReq = TAddBiosLogEntryReq

---@class BiosIpmiCmds.AddBiosLogEntryRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TAddBiosLogEntryRsp = {}
TAddBiosLogEntryRsp.__index = TAddBiosLogEntryRsp
TAddBiosLogEntryRsp.group = {}

local function TAddBiosLogEntryRsp_from_obj(obj)
    return setmetatable(obj, TAddBiosLogEntryRsp)
end

function TAddBiosLogEntryRsp.new(CompletionCode, ManufactureId)
    return TAddBiosLogEntryRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.AddBiosLogEntryRsp
function TAddBiosLogEntryRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TAddBiosLogEntryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddBiosLogEntryRsp.group)
end

TAddBiosLogEntryRsp.from_obj = TAddBiosLogEntryRsp_from_obj

TAddBiosLogEntryRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TAddBiosLogEntryRsp.default = {0, 0}

TAddBiosLogEntryRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TAddBiosLogEntryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TAddBiosLogEntryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddBiosLogEntryRsp.proto_property, errs, need_convert)
    return self
end

function TAddBiosLogEntryRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

AddBiosLogEntry.AddBiosLogEntryRsp = TAddBiosLogEntryRsp

return AddBiosLogEntry
