# BIOS

## 功能简介

bios组件主要是与带内交互模块，关键功能包含以下四个部分：

（1）配置：支持bios配置导入导出，支持启动项、启动模式设置，无感升级策略重配等

（2）证书：支持bios启动证书，bios安全启动证书，bios吊销证书管理

（3）升级：支持bios普通升级，无感升级，teeos升级（待实现）

（4）PFR：支持bios自愈功能

### 目录结构

```lua
├── src
│   ├── lualib-src
│   │   ├── CMakeLists.txt
│   │   └── mtd_api.c                               -- mtd驱动
│   ├── lualib
│   │   ├── bios_app.lua 					        -- bios_app文件
│   │   ├── domain
│   │   │   ├── bios_firmware
│   │   │   │   ├── defs.lua                        -- 固件定义信息文件
│   │   │   │   ├── gold                            -- bios固件
│   │   │   │   └── package                         -- bios升级包
│   │   │   ├── mapping
│   │   │   │   ├── component_info.lua              -- 无感升级文件基类
│   │   │   │   ├── component_manager.lua           -- 无感升级文件管理器
│   │   │   │   ├── component_version.lua           -- 无感升级版本文件
│   │   │   │   ├── policy_config_registery.lua     -- 策略重配registery文件
│   │   │   │   └── policy_config_value.lua         -- 策略重配当前值文件
│   │   │   ├── policy_config
│   │   │   │   ├── policy_config_transfer.lua      -- 策略重配转换
│   │   │   │   ├── policy_ipmi_format.lua          -- 策略重配ipmi命令格式转换
│   │   │   │   └── policy_registery.lua            -- 策略重配registery转换文件
│   │   │   └── transport
│   │   │       ├── component_communicate.lua       -- imu交互
│   │   │       ├── component_effective.lua         -- 无感升级生效
│   │   │       ├── component_info_query.lua        -- 查询无感升级文件
│   │   │       ├── component_process_query.lua     -- 查询无感升级进度
│   │   │       ├── component_send_confirmed.lua    -- 确认无感升级升结果
│   │   │       ├── component_upgrade.lua           -- 无感升级
│   │   │       └── imu_communicate.lua             -- imu交互
│   │   ├── factory
│   │   │   └── bios_factory.lua                    -- 工厂类
│   │   ├── handler
│   │   │   ├── bios_prop_handler.lua               -- 属性配置处理器
│   │   │   ├── config_handler.lua                  -- 配置处理器
│   │   │   ├── config_util.lua                     -- 配置处理器
│   │   │   ├── effective_time_handler.lua          -- 启动项生效次数处理器
│   │   │   ├── error_engineer.lua                  -- 错误引擎
│   │   │   ├── export_import_engine.lua            -- 导入导出处理器
│   │   │   ├── mode_handler.lua                    -- 启动模式处理器
│   │   │   └── start_option_handler.lua            -- 启动项处理器
│   │   ├── infrastructure
│   │   │   ├── chain.lua                           -- 责任链
│   │   │   ├── crc32.lua                           -- crc32
│   │   │   ├── file_util.lua                       -- 文件工具类
│   │   │   ├── firmware_upgrade.lua                -- 升级类
│   │   │   ├── fructl.lua                          -- 上下电类
│   │   │   ├── imu.lua                             -- imu交互类
│   │   │   ├── m3_verify.lua                       -- m3校验类
│   │   │   ├── power_lock.lua                      -- 上下电锁
│   │   │   ├── serialization_util.lua              -- 系列化列
│   │   │   └── spi_flash.lua                       -- spi工具
│   │   ├── interface
│   │   │   ├── mdb
│   │   │   │   └── firmware.lua                    -- 升级资源树
│   │   │   └── signal.lua                          -- 信号类
│   │   ├── pojo                                    -- 实体类
│   │   ├── service                                 -- 服务类
│   │   └── util                                    -- 工具类
│   └── service
│       └── main.lua                                -- app入口
```



## 关键特性

### 1、Bios升级

#### （1）介绍

​	Bios升级模式分为装备升级、非装备升级、无感升级。对于装备升级则会执行强制上下电，而非装备包不会。升级bios实质是将升级包的内容刷新到flash里面，对于无感升级底层是ipmb通道、而非无感升级底层是spi链路。

**升级模式区分**

| 升级模式     | 场景                                                         |
| ------------ | ------------------------------------------------------------ |
| 装备模式     | 打包manufacture文件夹（装备包）                              |
| 普通升级模式 | 未打包manufacture文件夹（装备包）                            |
| 无感升级模式 | 未打包manufacture文件夹（装备包）redfish下发无感升级（url：/redfish/v1/UpdateService/Actions/UpdateService.SimpleUpdate，且包含BiosActivatedScope参数） |

**升级动作区分**

| 升级模式           | 升级动作                                |
| ------------------ | --------------------------------------- |
| 装备升级           | 强制下电os，刷bios flash，上电os        |
| 非装备升级，os上电 | 缓存bios升级包，待下电刷flash（生效）   |
| 非装备升级，os下电 | 刷bios flash                            |
| 无感升级           | 通过ipmb通道将固件传到imu，实现在线升级 |

**升级包区分**

| 升级包类型             | 升级包的update.cfg |
| ---------------------- | ------------------ |
| 补丁包（无感升级的包） | 版本包含HPxxxx     |
| 普通包                 | 版本不包含HPxxxx   |

**升级场景匹配**

| 升级模式   | 升级包 | 是否不支持 |
| ---------- | ------ | ---------- |
| 装备升级   | 补丁包 | 不支持     |
| 装备升级   | 普通包 | 支持       |
| 非装备升级 | 补丁包 | 不支持     |
| 非装备升级 | 普通包 | 支持       |
| 无感升级   | 补丁包 | 支持       |
| 无感升级   | 普通包 | 不支持     |

#### （2）业务流程

升级生效流程如下：

bios升级流程，如下图所示，

- 首先判断是装备升级，然后判断是否补丁包，如果是补丁包则升级失败，否则就执行强制下电，通过spi链路将升级包写入flash，最后执行上电。
- 如果是非装备升级，则判断是无感升级，并且是否满足升级包为补丁包、os启动完成，如果满足则通过ipmb通道将升级包内容传到flash；否则升级失败。
- 如果是普通升级，判断当前os上下电状态，os上电则执行缓存升级包，os下电则通过spi链路将升级包写入flash。



![image](https://image.huawei.com/tiny-lts/v1/images/hi3ms/89ae4ff67134285059fca74a0c8c4fae_1546x903.png)

代码流程

bios升级流程分为prepare、process、finish阶段.

- prepare：此阶段主要解压升级包。
- process：此阶段主要是校验升级包、升级模式的合法性，以及将升级包通过spi或者ipmb通道传到flash中。
- finish：此阶段主要是做一些信息清理动作。

![image](https://image.huawei.com/tiny-lts/v1/images/hi3ms/7a2175753098f955c8c2996bc1385f10_2087x1181.png)

其中最关键的是upgrade_executor.lua中的一堆Executor，其是执行升级最关键的流程，Executor列表及作用如下：

| Executor名称         | Executor作用                                                 |
| -------------------- | ------------------------------------------------------------ |
| PackageCheckExecutor | 校验包合法性，如：冷升级不能升级补丁包、无感升级不能升级非补丁包、装备模式不能升级补丁包 |
| BackExecutor         | 将升级包压缩成bios.tar.gz                                    |
| Cache                | 上电升级缓存升级包，待下电生效                               |
| ForcePower           | 强制上下电，装备模式使用                                     |
| LockPower            | 上电锁，升级的时候需要锁住上下电，不允许上电                 |
| SpiDriver            | 加载spi驱动，通过spi可以将bin包内容刷入flash                 |
| DecompressFile       | 将bios.tar.gz解压成bin包（bin包大小与flash大小一样，地址也一致） |
| ParserBin            | 解析bin包，主要是header以及固件个数、固件大小、固件地址      |
| ComponentFilter      | 无感升级的时候，过滤版本一致的固件，这部分固件不升级         |
| SelectChannel        | 通道选择，无感升级（ipmb通道）、其他（spi链路）              |
| UpgradeComponent     | 升级固件                                                     |
| WaitUpgradeFinish    | 无感升级固件等待固件生效完成                                 |

#### （3）例子

**非无感升级**

- os下电场景下升级bios，可从带内界面看到bios升级中

**无感升级**

- 查询无感升级固件 URI：/redfish/v1/UpdateService/FirmwareInventory/Bios【其中Hotfix表示可以无感升级的固件】

![image](https://image.huawei.com/tiny-lts/v1/images/hi3ms/dad798557b4f2b2ac95f5cf4c933d60c_2952x1795.png)


- 触发无感升级，且可从日志中看到升级成功的打印，以及版本发生变化

    ```
    url：/redfish/v1/UpdateService/Actions/UpdateService.SimpleUpdate
    参数：
    {
    	"ImageURI":"/tmp/biosimage_patch.hpm",
    	"BiosActivatedScope":["IMU","IMP","SCC"] --由上一步可查询
    }
    ```

![image](https://image.huawei.com/tiny-lts/v1/images/hi3ms/658ffc763a17d28d11b4aab292884f7b_1673x1217.png)

### 2、Bios配置导入导出

#### （1）介绍

- 除了在Bios setup界面进行Bios配置，还支持通过BMC下发Bios配置给bios，涉及到以下文件：

    - setting.json ：用户的Bios配置数据

    - currentValue.json：当前生效的Bios配置

    - Registery.json：配置的标准文件（可以判断下发的配置是否正确）

    - result.json：Bios运行的记录文件


#### （2）实现机制

- 接口层：主要是进行注册rpc接口，包括导入导出的接口。

- 服务层：主要是业务逻辑的代码。比如：file_service具有导出导入BIOS配置的能力；registry_service 具有处理registry.json文件的能力。

- 数据层：考虑到磁盘读写速度慢的问题，将磁盘数据加载到内存中，提高读写速度。registry_object是对registry.json文件的抽象；setting_object是对currentvalue.json、setting.json的抽象。

  ![img](http://image.huawei.com/tiny-lts/v1/images/51b57efc362ea43eba7b352ef022f8e8_1014x544.png)

- 导入配置涉及2个json文件（registery.json配置标准文件、currentvalue.json当前生效配置），导入的时候首先会根据registery.json文件的Attribute判断导入的配置是否合法，如果不合法则返回报错；然后会根据registery.json的Dependency和currentvalue.json配置，判断当前导入的配置是否满足对应的依赖关系，如果满足则允许导入，否则导入失败。


![img](http://image.huawei.com/tiny-lts/v1/images/5b95c9ac20e92b6b991319830c2d399e_1348x690.png)



## 对外接口

### 资源树接口

- Path: `/bmc/kepler/Systems/${SystemId}/Bios`

- interface: `bmc.kepler.Systems.Bios`

  | 方法                   | 描述                       |
  | ---------------------- | -------------------------- |
  | ChangePassword         | 修改Bios密码               |
  | ClearCmos              | 清除Bios配置               |
  | ExportBiosSetup        | 导出Bios配置               |
  | GetCurrentValueSetting | 获取配置值                 |
  | ImportBiosSetup        | 导入Bios配置               |
  | ResetSetupConfig       | 清除Bios配置以及待生效配置 |
  | SetBiosLogEnabled      | 设置Bios全打印开关         |

- Path:` /bmc/kepler/Systems/${SystemId}/SecureBootOptions`
- interface: `bmc.kepler.Systems.SecureBootOptions`

| 方法              | 描述             |
| ----------------- | ---------------- |
| GetCertificate    | 获取安全启动证书 |
| ImportCertificate | 导入安全启动证书 |
| ResetCertificate  | 重置安全启动证书 |

- Path:` /bmc/kepler/Systems/${SystemId}/BootOptions`

- interface: `bmc.kepler.Systems.BootOptions`

  | 方法               | 描述               |
  | ------------------ | ------------------ |
  | GetCertificate     | 获取Bios Http证书  |
  | ImportCertificate  | 导入Bios Http证书  |
  | ImportCrl          | 导入Bios吊销证书   |
  | ResetCertificate   | 重置Bios Http证书  |
  | ResetCrl           | 重置Bios吊销证书   |
  | SetBootMode        | 设置启动模式       |
  | SetBootOrder       | 设置启动顺序       |
  | SetStartOption     | 设置启动项         |
  | SetStartOptionFlag | 设置启动项生效次数 |

- Path:` /bmc/kepler/Systems/${SystemId}/BiosUpgradeService`

- interface: `bmc.kepler.Systems.BiosUpgradeService`

  | 方法               | 描述             |
  | ------------------ | ---------------- |
  | ActivateFirmware   | 固件生效         |
  | ExportBiosFirmware | 导出bios固件信息 |

  

### ipmi接口

| 命令                          | 描述                                     |
| ----------------------------- | :--------------------------------------- |
| SetBootOption                 | 设置启动项                               |
| GetBootOption                 | 获取启动项                               |
| SetBridgeSystemInfo           | 设置启动项（BridgeSystemInfo）           |
| SetChannelInfo                | 设置启动项（ChannelInfo）                |
| SetDeviceSystemInfo           | 设置启动项（DeviceSystemInfo）           |
| SetOperatingSystemName        | 设置启动项（OperatingSystemNam）         |
| SetPrimaryOperatingSystemName | 设置启动项（PrimaryOperatingSystemName） |
| SetProgressSystemInfo         | 设置启动项（ProgressSystemInfo）         |
| SetSystemName                 | 设置启动项（SystemName）                 |
| WriteOcpCardBdfToBmc          | 设置OCP卡的BDF                           |
| WritePcieCardBdfToBmc         | 设置PCIE卡的BDF                          |
| WritePcieDiskBdfToBmc         | 设置硬盘的BDF                            |
| GetBridgeSystemInfo           | 获取启动项（BridgeSystemInfo）           |
| GetChannelInfo                | 获取启动项（ChannelInfo）                |
| GetDeviceSystemInfo           | 获取启动项（DeviceSystemInfo）           |
| GetOperatingSystemName        | 获取启动项（OperatingSystemName）        |
| GetPrimaryOperatingSystemName | 获取启动项（PrimaryOperatingSystemName） |
| GetProgressSystemInfo         | 获取启动项（ProgressSystemInfo）         |
| GetSystemFirmwareVersion      | 获取启动项（SystemFirmwareVersion）      |
| GetSystemName                 | 获取启动项（SystemName）                 |
| GetBiosGoldValid              | 获取固件备份状态                         |
| AddBiosLogEntry               | 设置bios日志信息                         |
| GetBiosBootInfo               | 获取bios启动参数                         |
| GetFileChanged                | 获取bios配置文件修改状态                 |
| GetSmBiosInfo                 | 获取smbios信息                           |
| ReadFileFromBmc               | 从bmc读取配置文件                        |
| SetBiosBootInfo               | 设置bios启动参数                         |
| SetBiosVersion                | 设置bios版本                             |
| SetCertificateAssertion       | 设置bios证书过期告警                     |
| SetFileChanged                | 设置bios配置文件修改状态                 |
| SetSmBiosInfo                 | 设置smbios信息                           |
| UpdateBiosPassword            | 设置bios密码                             |
| UpdateBiosStatus              | 设置bios启动状态                         |
| UpdatePostStatus              | 设置bios完成启动状态                     |
| WriteFileToBmc                | 上报bios配置文件                         |
| WriteSmbiosData               | 上报smbios配置文件                       |



## 配置介绍

不涉及



###  



