#!/bin/bash
# Package the firmware upgrade scripts in the IPMC and DATA areas.
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

# 升级前执行脚本,暂时为空,修改了此文件需要修改CfgFileList.conf中相应的文件大小值,
# 打包时会自动脚本packethpm.sh会自动更新大小

NVM_TEMP_MOUNT_DIR="/dev/shm/bmc_mount"
APP_LOG=/var/log/app.log

app_log()
{
    echo -e $(date  +"%Y-%m-%d %T.%6N")" $1" >> $APP_LOG
}

# 处理bmc_upgrade初始化阶段umount nvm_temp分区失败，后升级时导致分区损坏问题
try_umount_nvm_temp()
{
    if [ -d "${NVM_TEMP_MOUNT_DIR}" ] ; then
        app_log "find nvm_temp exist, try to umount and remove"
        for i in 1 2 3 4 5 6 7 8 9 10
        do
            umount "${NVM_TEMP_MOUNT_DIR}"
            if [ $? -eq 0 ]; then
                rm -rf "${NVM_TEMP_MOUNT_DIR}"
                app_log "umount nvm_temp successfully"
                return
            fi
            sleep 1
        done
        app_log "umount nvm_temp failed"
    fi
}

main()
{
    try_umount_nvm_temp
}

main
