# cms签名Demo

## 安全说明
签名涉及多个证书的公私钥，私钥泄露存在严重的安全风险，建议根证书私钥和加密密钥离线分人保存。该demo仅用于功能演示，请根据实际情况进行完善和安全加固。


## 自制签名证书链

依次执行以下步骤：

1. 准备好加密密码（可通过`openssl rand -hex 32`生成），将`1_create_ca.sh`中`rootca.cnf`配置里的组织名称`O`和证书名称`CN`变更为实际真实的名称， 执行`sh 1_create_ca.sh`生成CA根证书。
2. 将`2_create_sign_ca.sh`中`sign_cert.cnf`配置里的的组织名称`O`和证书名称`CN`变更为实际真实的名称， 执行`sh 2_create_sign_ca.sh`生成签名证书。
3. 执行`sh 3_create_crl.sh`生成吊销列表。
4. 将`4_create_sign_ts.sh`中`tsa.cnf`配置里的的组织名称`O`和证书名称`CN`变更为实际真实的名称， 执行`sh 4_create_sign_ts.sh`生成时间戳签名证书。
5. 准备好签名证书加密密码（可通过`openssl rand -hex 16`生成）， 执行`sh 5_crypto_cert.sh`生成加密后的签名证书。


### 吊销证书

当前证书过期或证书泄露等原因需要吊销证书时，执行以下命令重新生成新的rootca.crl文件代替旧的rootca.crl文件。
```shell
openssl ca -config crl/crl.cnf -revoke signer.pem 
openssl ca -gencrl -config crl/crl.cnf -out rootca.crl.pem
openssl crl -infrom pem -in rootca.crl.pem -outform der -out rootca.crl
rm rootca.crl.pem
```


## 自制简易签名服务器

`sign_server.py`仅为简易实现，未处理异常情况和安全加固，请自行完善。

1. 提前安装flask（`pip3 install flask`)
2. 执行python3 sign_server.py -certs `</xxx/yyy/certs>` -sp `<abcd>`在本地`8098`端口启动签名服务器，其中</xxx/yyy/certs>为存放证书的路径，abcd为签名证书加密密码（通过参数传入存在泄露风险，当前仅作演示，生成环境通过CI环境私密参数传入）。


## 测试验证

1. 生成待签名测试文件
```shell
dd if=/dev/random of=unsigned.img bs=1k count=1
```
2. 使用bingo简易签名命令进行签名
```
bingo simple_sign -i unsigned.img -u http://localhost:8098/sign -s "abc-egh"
```
