#!/usr/bin/env python3
# coding: utf-8
# Copyright (c) 2025 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.


mkdir crl -p
cat << EOF > crl/crl.cnf
[ ca ]
default_ca=CA_default

[ CA_default ]
database=./crl/crlindex
crlnumber=./crl/crlnumber
private_key=./rootca_pri.pem
certificate=./rootca.pem
crl_extensions=crl_ext
default_days=365
default_crl_days=365
default_md=default
preserve=no

[ crl_ext ]
authorityKeyIdentifier=keyid
EOF

touch crl/crlindex
echo 01 > crl/crlnumber

openssl pkcs12 -nocerts -nodes -in rootca.pfx -out rootca_pri.pem

openssl ca -gencrl -keyfile rootca_pri.pem -cert rootca.pem -config crl/crl.cnf -out crl.pem 

openssl crl -inform pem -in crl.pem  -outform der -out rootca.crl

rm -rf rootca_pri.pem crl.pem
