#!/usr/bin/env python3
# coding: utf-8
# Copyright (c) 2025 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.


cat << EOF > sign_cert.cnf
[ req ]
default_bits = 4096
distinguished_name = req_distinguished_name
prompt = no
default_md = sha256
string_mask = utf8only
x509_extensions = extensions

[ req_distinguished_name ]
C = CN
O = Test
CN = Test Enterprise

[ extensions ]
subjectKeyIdentifier = hash
authorityKeyIdentifier = keyid, issuer
basicConstraints = CA:FALSE
keyUsage = critical, digitalSignature, nonRepudiation
extendedKeyUsage = codeSigning
EOF


openssl genrsa -out sign_cert_pri.pem 4096

openssl req -new -config sign_cert.cnf -key sign_cert_pri.pem -out sign_cert.csr

openssl pkcs12 -nocerts -nodes -in rootca.pfx -out rootca_pri.pem

openssl x509 -req -in sign_cert.csr -CA rootca.pem -CAkey rootca_pri.pem -days 365 -CAcreateserial -extensions extensions -extfile sign_cert.cnf -out sign_cert.pem

cat sign_cert.pem sign_cert_pri.pem > signer.pem

rm -f rootca_pri.pem sign_cert.cnf sign_cert_pri.pem sign_cert.pem rootca.srl sign_cert.csr
