#!/usr/bin/env python3
# coding: utf-8
# Copyright (c) 2025 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
import os
import sys


def debug_init(debug_target_relative_path: str):
    dir_path = os.path.dirname(os.path.realpath(__file__))
    if os.getcwd() != dir_path:
        os.chdir(dir_path)

    os.chdir(debug_target_relative_path)


def debug(debug_target_relative_path: str, command: str):
    debug_init(debug_target_relative_path)

    from bmcgo.cli import cli

    args = command.split()[1:]
    sys.argv.extend(args)
    cli.main(args)


# 调试执行bingo命令的目录相对debug.py的相对路径，默认为bingo的当前路径
DEBUG_TARGET_RELATIVE_PATH = "."
# 需要调试的bingo命令，默认为bingo help
DEBUG_COMMAND = "bingo help"
debug(DEBUG_TARGET_RELATIVE_PATH, DEBUG_COMMAND)
