-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- IPMI错误码定义
local USER_OPER_SUCCESS = 0x00
local USER_NAME_EXIST = 0x80
local USER_DONT_EXIST = 0x81
local INVALID_PASSWORD = 0x82          -- 用户密码错误 
local USER_IS_LOCKED = 0x83            -- 用户被锁定 
local USER_PASS_COMPLEXITY_FAIL = 0x84 -- 口令复杂度检测 
local USER_USERPASS_TOO_LONG = -182    -- 密码长度超长
local USER_UNLOCK_FAIL = 0x85
local PERMIT_RULE_INVALID = 0x86
local USER_MGNT_OPERATION_DISABLED = 0x87 -- 用户管理操作未使能 
local USER_NO_ACCESS = 0x88               -- 用户无权访问 
local USER_PASSWORD_EXPIRED = 0x89        -- 口令过期 
local USER_LOGIN_LIMITED = 0x90           -- 登录受限 
local USER_TIME_LIMIT_UNREASONABLE = 0x91 -- 密码有效期设置短于密码最短使用期限 
local USER_PUBLIC_KEY_FORMAT_ERROR = 0x92 -- 公钥格式错误，支持RFC4716，Openssh格式 
local USER_CANNT_SET_SAME_PASSWORD = 0x93 -- 开启了历史密码检测，还设置历史密码 
local USER_SET_PASSWORD_EMPTY = 0x94
local USER_SET_PASSWORD_TOO_WEAK = 0x95 -- 密码在弱口令字典 
local USER_PASSWORD_NEED_RESET = 0x96   -- 用户的密码是初始密码或者是其他管理员设置，人机接口使用前必须先重设再使用
local USER_NODE_BUSY = 0xc0
local USER_COMMAND_NORMALLY = 0x00
local USER_REQ_LENGTH_INVALID = 0xC7
local USER_PARAMETER_OUT_OF_RANGE = 0xC9
local USER_INVALID_DATA_FIELD = 0xCC
local USER_DATA_LENGTH_INVALID = 0xC7
local USER_UNSUPPORT = 0xD5
local UNKNOWN = 0x2E
local USER_DELETE_TRAPV3_USER_UNSUPPORT = 0xD7   -- 用户被设置为SNMP Trap V3的用户，不能删除
local USER_DELETE_EXCLUDE_USER_UNSURPPORT = 0xD9 -- 用户被设置为逃生用户，不能删除
local USER_LDAP_LOGIN_FAIL = 0xDA -- LDAP用户登录失败

local PASSWORD_TEST_FAILED1 = 0X80 -- 密码测试失败。密码长度正确，内容不正确
local STATE_ENABLE = 0x01   -- IPMI状态使能开
local STATE_DISABLE = 0x00  -- IPMI状态使能关

-- 远程文件传输错误码
local FILE_TRANSFER_ERR_CODE = {
  UNKNOWN_ERROR = -1,
  FILENAME_TOO_LONG = -102,
  FILELEN_OUTOF_MAX  = -103,
  SET_UPDATEFLAG_ERROR =  -104,
  CURL_RUN_ERROR = -105,
  TRANSFILE_UNSUPPORTED_PROTOCOL =  -108,
  TRANSFILE_URL_FORMAT_ERR  = -109,
  UMS_BUSY_ERROR = -110,
  MOUNT_FILE_UNAVAILABLE = -111,
  CMS_AUTH_ERROR = -112,
  IMAGEURI_IS_ILLEGAL = -113,
  UMS_TRANSFER_TIMEOUT = -114,
  SP_IS_BUSY = -115,
  UPGRADE_SP_ERROR = -116,
  FIND_CLASS_ERROR = -117,
  MOUNT_UMS_UNAVAILABLE = -118,
  SP_OF_X86_NEEDED = -119,
  SP_OF_ARM_NEEDED = -120,
  IN_UPGRADE_PROGRESS = -121,
  CURL_PEER_SSL_VERIFY_FAILED = -122,
  NO_PERMISSION_TO_OPERATE_FILE = -123
}

-- 远程文件传输错误对应message
local FILE_TRANSFER_ERR_STR = {
  [FILE_TRANSFER_ERR_CODE.UNKNOWN_ERROR] = 'unknown error',
  [FILE_TRANSFER_ERR_CODE.FILENAME_TOO_LONG] = 'the length of filename exceeds the limit',
  [FILE_TRANSFER_ERR_CODE.FILELEN_OUTOF_MAX] = 'failed to obtain the file length,' ..
      ' or the file length exceeds the limit or out of memory',
  [FILE_TRANSFER_ERR_CODE.SET_UPDATEFLAG_ERROR] = 'unknown error',
  [FILE_TRANSFER_ERR_CODE.CURL_RUN_ERROR] = "file transfer failed, cann't finish file transfer process",
  [FILE_TRANSFER_ERR_CODE.TRANSFILE_UNSUPPORTED_PROTOCOL] =
      'transfer protocol is not allowed to use in current situation',
  [FILE_TRANSFER_ERR_CODE.TRANSFILE_URL_FORMAT_ERR] = 'incorrect file path',
  [FILE_TRANSFER_ERR_CODE.UMS_BUSY_ERROR] = 'The SP is being used by x86 system',
  [FILE_TRANSFER_ERR_CODE.MOUNT_FILE_UNAVAILABLE] =
      'The shared folder is faulty and cannot be mounted to the BMC. Ensure that the shared folder can be accessed',
  [FILE_TRANSFER_ERR_CODE.CMS_AUTH_ERROR] = 'The file verification fails because the URI or SP file is incorrect',
  [FILE_TRANSFER_ERR_CODE.IMAGEURI_IS_ILLEGAL] = 'The URI format is incorrect',
  [FILE_TRANSFER_ERR_CODE.UMS_TRANSFER_TIMEOUT] = 'File transfer timed out. Please check the network environment',
  [FILE_TRANSFER_ERR_CODE.SP_IS_BUSY] = 'The SP is busy. Please try again',
  [FILE_TRANSFER_ERR_CODE.UPGRADE_SP_ERROR] = 'unknown error',
  [FILE_TRANSFER_ERR_CODE.FIND_CLASS_ERROR] = 'unknown error',
  [FILE_TRANSFER_ERR_CODE.MOUNT_UMS_UNAVAILABLE] = 'unknown error',
  [FILE_TRANSFER_ERR_CODE.SP_OF_X86_NEEDED] = 'Please insert the SmartProvisioning DVD for the x86_64 architecture',
  [FILE_TRANSFER_ERR_CODE.SP_OF_ARM_NEEDED] = 'Please insert the SmartProvisioning DVD for the aarch64 architecture',
  [FILE_TRANSFER_ERR_CODE.IN_UPGRADE_PROGRESS] = 'Component is being upgraded',
  [FILE_TRANSFER_ERR_CODE.CURL_PEER_SSL_VERIFY_FAILED] = "peer's certificate or fingerprint wasn't verified fine",
  [FILE_TRANSFER_ERR_CODE.NO_PERMISSION_TO_OPERATE_FILE] = 'have no permission to overwrite the same file'
}

return {
  USER_OPER_SUCCESS = USER_OPER_SUCCESS,
  USER_NAME_EXIST = USER_NAME_EXIST,
  USER_DONT_EXIST = USER_DONT_EXIST,
  INVALID_PASSWORD = INVALID_PASSWORD,
  USER_IS_LOCKED = USER_IS_LOCKED,
  USER_PASS_COMPLEXITY_FAIL = USER_PASS_COMPLEXITY_FAIL,
  USER_USERPASS_TOO_LONG = USER_USERPASS_TOO_LONG,
  USER_UNLOCK_FAIL = USER_UNLOCK_FAIL,
  PERMIT_RULE_INVALID = PERMIT_RULE_INVALID,
  USER_MGNT_OPERATION_DISABLED = USER_MGNT_OPERATION_DISABLED,
  USER_NO_ACCESS = USER_NO_ACCESS,
  USER_PASSWORD_EXPIRED = USER_PASSWORD_EXPIRED,
  USER_LOGIN_LIMITED = USER_LOGIN_LIMITED,
  USER_TIME_LIMIT_UNREASONABLE = USER_TIME_LIMIT_UNREASONABLE,
  USER_PUBLIC_KEY_FORMAT_ERROR = USER_PUBLIC_KEY_FORMAT_ERROR,
  USER_CANNT_SET_SAME_PASSWORD = USER_CANNT_SET_SAME_PASSWORD,
  USER_SET_PASSWORD_EMPTY = USER_SET_PASSWORD_EMPTY,
  USER_SET_PASSWORD_TOO_WEAK = USER_SET_PASSWORD_TOO_WEAK,
  USER_PASSWORD_NEED_RESET = USER_PASSWORD_NEED_RESET,
  USER_NODE_BUSY = USER_NODE_BUSY,
  USER_COMMAND_NORMALLY = USER_COMMAND_NORMALLY,
  USER_REQ_LENGTH_INVALID = USER_REQ_LENGTH_INVALID,
  USER_PARAMETER_OUT_OF_RANGE = USER_PARAMETER_OUT_OF_RANGE,
  USER_INVALID_DATA_FIELD = USER_INVALID_DATA_FIELD,
  USER_DATA_LENGTH_INVALID = USER_DATA_LENGTH_INVALID,
  USER_UNSUPPORT = USER_UNSUPPORT,
  UNKNOWN = UNKNOWN,
  USER_DELETE_TRAPV3_USER_UNSUPPORT = USER_DELETE_TRAPV3_USER_UNSUPPORT,
  USER_DELETE_EXCLUDE_USER_UNSURPPORT = USER_DELETE_EXCLUDE_USER_UNSURPPORT,
  USER_LDAP_LOGIN_FAIL = USER_LDAP_LOGIN_FAIL,
  PASSWORD_TEST_FAILED1 = PASSWORD_TEST_FAILED1,
  STATE_ENABLE = STATE_ENABLE,
  STATE_DISABLE = STATE_DISABLE,

  -- file fransfer error code map
  FILE_TRANSFER_ERR_CODE = FILE_TRANSFER_ERR_CODE,
  FILE_TRANSFER_ERR_STR = FILE_TRANSFER_ERR_STR
}
