-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MSNMPUserInfo = {}

---@class MSNMPUserInfo.SnmpEncryptionPasswordInitialStatus
---@field SnmpEncryptionPasswordInitialStatus boolean
local TSnmpEncryptionPasswordInitialStatus = {}
TSnmpEncryptionPasswordInitialStatus.__index = TSnmpEncryptionPasswordInitialStatus
TSnmpEncryptionPasswordInitialStatus.group = {}

local function TSnmpEncryptionPasswordInitialStatus_from_obj(obj)
    return setmetatable(obj, TSnmpEncryptionPasswordInitialStatus)
end

function TSnmpEncryptionPasswordInitialStatus.new(SnmpEncryptionPasswordInitialStatus)
    return TSnmpEncryptionPasswordInitialStatus_from_obj({
        SnmpEncryptionPasswordInitialStatus = SnmpEncryptionPasswordInitialStatus == nil and true or
            SnmpEncryptionPasswordInitialStatus
    })
end
---@param obj MSNMPUserInfo.SnmpEncryptionPasswordInitialStatus
function TSnmpEncryptionPasswordInitialStatus:init_from_obj(obj)
    self.SnmpEncryptionPasswordInitialStatus = obj.SnmpEncryptionPasswordInitialStatus == nil and true or
                                                   obj.SnmpEncryptionPasswordInitialStatus
end

function TSnmpEncryptionPasswordInitialStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSnmpEncryptionPasswordInitialStatus.group)
end

TSnmpEncryptionPasswordInitialStatus.from_obj = TSnmpEncryptionPasswordInitialStatus_from_obj

TSnmpEncryptionPasswordInitialStatus.proto_property = {'SnmpEncryptionPasswordInitialStatus'}

TSnmpEncryptionPasswordInitialStatus.default = {false}

TSnmpEncryptionPasswordInitialStatus.struct = {
    {name = 'SnmpEncryptionPasswordInitialStatus', is_array = false, struct = nil}
}

function TSnmpEncryptionPasswordInitialStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SnmpEncryptionPasswordInitialStatus', self.SnmpEncryptionPasswordInitialStatus, 'bool',
        false, errs, need_convert)

    TSnmpEncryptionPasswordInitialStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSnmpEncryptionPasswordInitialStatus.proto_property, errs, need_convert)
    return self
end

function TSnmpEncryptionPasswordInitialStatus:unpack(_)
    return self.SnmpEncryptionPasswordInitialStatus
end

MSNMPUserInfo.SnmpEncryptionPasswordInitialStatus = TSnmpEncryptionPasswordInitialStatus

---@class MSNMPUserInfo.SNMPKDFPassword
---@field SNMPKDFPassword string
local TSNMPKDFPassword = {}
TSNMPKDFPassword.__index = TSNMPKDFPassword
TSNMPKDFPassword.group = {}

local function TSNMPKDFPassword_from_obj(obj)
    return setmetatable(obj, TSNMPKDFPassword)
end

function TSNMPKDFPassword.new(SNMPKDFPassword)
    return TSNMPKDFPassword_from_obj({SNMPKDFPassword = SNMPKDFPassword})
end
---@param obj MSNMPUserInfo.SNMPKDFPassword
function TSNMPKDFPassword:init_from_obj(obj)
    self.SNMPKDFPassword = obj.SNMPKDFPassword
end

function TSNMPKDFPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSNMPKDFPassword.group)
end

TSNMPKDFPassword.from_obj = TSNMPKDFPassword_from_obj

TSNMPKDFPassword.proto_property = {'SNMPKDFPassword'}

TSNMPKDFPassword.default = {''}

TSNMPKDFPassword.struct = {{name = 'SNMPKDFPassword', is_array = false, struct = nil}}

function TSNMPKDFPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SNMPKDFPassword', self.SNMPKDFPassword, 'string', false, errs, need_convert)

    TSNMPKDFPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSNMPKDFPassword.proto_property, errs, need_convert)
    return self
end

function TSNMPKDFPassword:unpack(_)
    return self.SNMPKDFPassword
end

MSNMPUserInfo.SNMPKDFPassword = TSNMPKDFPassword

---@class MSNMPUserInfo.SNMPPassword
---@field SNMPPassword string
local TSNMPPassword = {}
TSNMPPassword.__index = TSNMPPassword
TSNMPPassword.group = {}

local function TSNMPPassword_from_obj(obj)
    return setmetatable(obj, TSNMPPassword)
end

function TSNMPPassword.new(SNMPPassword)
    return TSNMPPassword_from_obj({SNMPPassword = SNMPPassword})
end
---@param obj MSNMPUserInfo.SNMPPassword
function TSNMPPassword:init_from_obj(obj)
    self.SNMPPassword = obj.SNMPPassword
end

function TSNMPPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSNMPPassword.group)
end

TSNMPPassword.from_obj = TSNMPPassword_from_obj

TSNMPPassword.proto_property = {'SNMPPassword'}

TSNMPPassword.default = {''}

TSNMPPassword.struct = {{name = 'SNMPPassword', is_array = false, struct = nil}}

function TSNMPPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SNMPPassword', self.SNMPPassword, 'string', false, errs, need_convert)

    TSNMPPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSNMPPassword.proto_property, errs, need_convert)
    return self
end

function TSNMPPassword:unpack(_)
    return self.SNMPPassword
end

MSNMPUserInfo.SNMPPassword = TSNMPPassword

---@class MSNMPUserInfo.EncryptionProtocol
---@field EncryptionProtocol def_types.SNMPEncryptionProtocols
local TEncryptionProtocol = {}
TEncryptionProtocol.__index = TEncryptionProtocol
TEncryptionProtocol.group = {}

local function TEncryptionProtocol_from_obj(obj)
    obj.EncryptionProtocol = obj.EncryptionProtocol and def_types.SNMPEncryptionProtocols.new(obj.EncryptionProtocol)
    return setmetatable(obj, TEncryptionProtocol)
end

function TEncryptionProtocol.new(EncryptionProtocol)
    return TEncryptionProtocol_from_obj({EncryptionProtocol = EncryptionProtocol or [=[AES128]=]})
end
---@param obj MSNMPUserInfo.EncryptionProtocol
function TEncryptionProtocol:init_from_obj(obj)
    self.EncryptionProtocol = obj.EncryptionProtocol or def_types.SNMPEncryptionProtocols.AES128
end

function TEncryptionProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEncryptionProtocol.group)
end

TEncryptionProtocol.from_obj = TEncryptionProtocol_from_obj

TEncryptionProtocol.proto_property = {'EncryptionProtocol'}

TEncryptionProtocol.default = {def_types.SNMPEncryptionProtocols.default}

TEncryptionProtocol.struct = {
    {name = 'EncryptionProtocol', is_array = false, struct = def_types.SNMPEncryptionProtocols.struct}
}

function TEncryptionProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EncryptionProtocol', self.EncryptionProtocol, 'def_types.SNMPEncryptionProtocols',
        false, errs, need_convert)

    TEncryptionProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEncryptionProtocol.proto_property, errs, need_convert)
    return self
end

function TEncryptionProtocol:unpack(raw)
    local EncryptionProtocol = utils.unpack_enum(raw, self.EncryptionProtocol)
    return EncryptionProtocol
end

MSNMPUserInfo.EncryptionProtocol = TEncryptionProtocol

---@class MSNMPUserInfo.EncryptionKeySet
---@field EncryptionKeySet boolean
local TEncryptionKeySet = {}
TEncryptionKeySet.__index = TEncryptionKeySet
TEncryptionKeySet.group = {}

local function TEncryptionKeySet_from_obj(obj)
    return setmetatable(obj, TEncryptionKeySet)
end

function TEncryptionKeySet.new(EncryptionKeySet)
    return TEncryptionKeySet_from_obj({EncryptionKeySet = EncryptionKeySet or false})
end
---@param obj MSNMPUserInfo.EncryptionKeySet
function TEncryptionKeySet:init_from_obj(obj)
    self.EncryptionKeySet = obj.EncryptionKeySet or false
end

function TEncryptionKeySet:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEncryptionKeySet.group)
end

TEncryptionKeySet.from_obj = TEncryptionKeySet_from_obj

TEncryptionKeySet.proto_property = {'EncryptionKeySet'}

TEncryptionKeySet.default = {false}

TEncryptionKeySet.struct = {{name = 'EncryptionKeySet', is_array = false, struct = nil}}

function TEncryptionKeySet:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EncryptionKeySet', self.EncryptionKeySet, 'bool', false, errs, need_convert)

    TEncryptionKeySet:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEncryptionKeySet.proto_property, errs, need_convert)
    return self
end

function TEncryptionKeySet:unpack(_)
    return self.EncryptionKeySet
end

MSNMPUserInfo.EncryptionKeySet = TEncryptionKeySet

---@class MSNMPUserInfo.EncryptionKey
---@field EncryptionKey string
local TEncryptionKey = {}
TEncryptionKey.__index = TEncryptionKey
TEncryptionKey.group = {}

local function TEncryptionKey_from_obj(obj)
    return setmetatable(obj, TEncryptionKey)
end

function TEncryptionKey.new(EncryptionKey)
    return TEncryptionKey_from_obj({EncryptionKey = EncryptionKey})
end
---@param obj MSNMPUserInfo.EncryptionKey
function TEncryptionKey:init_from_obj(obj)
    self.EncryptionKey = obj.EncryptionKey
end

function TEncryptionKey:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEncryptionKey.group)
end

TEncryptionKey.from_obj = TEncryptionKey_from_obj

TEncryptionKey.proto_property = {'EncryptionKey'}

TEncryptionKey.default = {''}

TEncryptionKey.struct = {{name = 'EncryptionKey', is_array = false, struct = nil}}

function TEncryptionKey:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'EncryptionKey', self.EncryptionKey, 'string', false, errs, need_convert)

    TEncryptionKey:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEncryptionKey.proto_property, errs, need_convert)
    return self
end

function TEncryptionKey:unpack(_)
    return self.EncryptionKey
end

MSNMPUserInfo.EncryptionKey = TEncryptionKey

---@class MSNMPUserInfo.AuthenticationProtocol
---@field AuthenticationProtocol def_types.SNMPAuthenticationProtocols
local TAuthenticationProtocol = {}
TAuthenticationProtocol.__index = TAuthenticationProtocol
TAuthenticationProtocol.group = {}

local function TAuthenticationProtocol_from_obj(obj)
    obj.AuthenticationProtocol = obj.AuthenticationProtocol and
                                     def_types.SNMPAuthenticationProtocols.new(obj.AuthenticationProtocol)
    return setmetatable(obj, TAuthenticationProtocol)
end

function TAuthenticationProtocol.new(AuthenticationProtocol)
    return TAuthenticationProtocol_from_obj({AuthenticationProtocol = AuthenticationProtocol or [=[SHA256]=]})
end
---@param obj MSNMPUserInfo.AuthenticationProtocol
function TAuthenticationProtocol:init_from_obj(obj)
    self.AuthenticationProtocol = obj.AuthenticationProtocol or def_types.SNMPAuthenticationProtocols.SHA256
end

function TAuthenticationProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticationProtocol.group)
end

TAuthenticationProtocol.from_obj = TAuthenticationProtocol_from_obj

TAuthenticationProtocol.proto_property = {'AuthenticationProtocol'}

TAuthenticationProtocol.default = {def_types.SNMPAuthenticationProtocols.default}

TAuthenticationProtocol.struct = {
    {name = 'AuthenticationProtocol', is_array = false, struct = def_types.SNMPAuthenticationProtocols.struct}
}

function TAuthenticationProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuthenticationProtocol', self.AuthenticationProtocol,
        'def_types.SNMPAuthenticationProtocols', false, errs, need_convert)

    TAuthenticationProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticationProtocol.proto_property, errs, need_convert)
    return self
end

function TAuthenticationProtocol:unpack(raw)
    local AuthenticationProtocol = utils.unpack_enum(raw, self.AuthenticationProtocol)
    return AuthenticationProtocol
end

MSNMPUserInfo.AuthenticationProtocol = TAuthenticationProtocol

---@class MSNMPUserInfo.AuthenticationKeySet
---@field AuthenticationKeySet boolean
local TAuthenticationKeySet = {}
TAuthenticationKeySet.__index = TAuthenticationKeySet
TAuthenticationKeySet.group = {}

local function TAuthenticationKeySet_from_obj(obj)
    return setmetatable(obj, TAuthenticationKeySet)
end

function TAuthenticationKeySet.new(AuthenticationKeySet)
    return TAuthenticationKeySet_from_obj({AuthenticationKeySet = AuthenticationKeySet or false})
end
---@param obj MSNMPUserInfo.AuthenticationKeySet
function TAuthenticationKeySet:init_from_obj(obj)
    self.AuthenticationKeySet = obj.AuthenticationKeySet or false
end

function TAuthenticationKeySet:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticationKeySet.group)
end

TAuthenticationKeySet.from_obj = TAuthenticationKeySet_from_obj

TAuthenticationKeySet.proto_property = {'AuthenticationKeySet'}

TAuthenticationKeySet.default = {false}

TAuthenticationKeySet.struct = {{name = 'AuthenticationKeySet', is_array = false, struct = nil}}

function TAuthenticationKeySet:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuthenticationKeySet', self.AuthenticationKeySet, 'bool', false, errs, need_convert)

    TAuthenticationKeySet:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticationKeySet.proto_property, errs, need_convert)
    return self
end

function TAuthenticationKeySet:unpack(_)
    return self.AuthenticationKeySet
end

MSNMPUserInfo.AuthenticationKeySet = TAuthenticationKeySet

---@class MSNMPUserInfo.AuthenticationKey
---@field AuthenticationKey string
local TAuthenticationKey = {}
TAuthenticationKey.__index = TAuthenticationKey
TAuthenticationKey.group = {}

local function TAuthenticationKey_from_obj(obj)
    return setmetatable(obj, TAuthenticationKey)
end

function TAuthenticationKey.new(AuthenticationKey)
    return TAuthenticationKey_from_obj({AuthenticationKey = AuthenticationKey})
end
---@param obj MSNMPUserInfo.AuthenticationKey
function TAuthenticationKey:init_from_obj(obj)
    self.AuthenticationKey = obj.AuthenticationKey
end

function TAuthenticationKey:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticationKey.group)
end

TAuthenticationKey.from_obj = TAuthenticationKey_from_obj

TAuthenticationKey.proto_property = {'AuthenticationKey'}

TAuthenticationKey.default = {''}

TAuthenticationKey.struct = {{name = 'AuthenticationKey', is_array = false, struct = nil}}

function TAuthenticationKey:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'AuthenticationKey', self.AuthenticationKey, 'string', false, errs, need_convert)

    TAuthenticationKey:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticationKey.proto_property, errs, need_convert)
    return self
end

function TAuthenticationKey:unpack(_)
    return self.AuthenticationKey
end

MSNMPUserInfo.AuthenticationKey = TAuthenticationKey

---@class MSNMPUserInfo.AccountId
---@field AccountId integer
local TAccountId = {}
TAccountId.__index = TAccountId
TAccountId.group = {}

local function TAccountId_from_obj(obj)
    return setmetatable(obj, TAccountId)
end

function TAccountId.new(AccountId)
    return TAccountId_from_obj({AccountId = AccountId})
end
---@param obj MSNMPUserInfo.AccountId
function TAccountId:init_from_obj(obj)
    self.AccountId = obj.AccountId
end

function TAccountId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountId.group)
end

TAccountId.from_obj = TAccountId_from_obj

TAccountId.proto_property = {'AccountId'}

TAccountId.default = {0}

TAccountId.struct = {{name = 'AccountId', is_array = false, struct = nil}}

function TAccountId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'AccountId', self.AccountId, 'uint8', false, errs, need_convert)

    TAccountId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountId.proto_property, errs, need_convert)
    return self
end

function TAccountId:unpack(_)
    return self.AccountId
end

MSNMPUserInfo.AccountId = TAccountId

return MSNMPUserInfo
