-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MHistoryPassword = {}

---@class MHistoryPassword.KDFPassword
---@field KDFPassword string
local TKDFPassword = {}
TKDFPassword.__index = TKDFPassword
TKDFPassword.group = {}

local function TKDFPassword_from_obj(obj)
    return setmetatable(obj, TKDFPassword)
end

function TKDFPassword.new(KDFPassword)
    return TKDFPassword_from_obj({KDFPassword = KDFPassword})
end
---@param obj MHistoryPassword.KDFPassword
function TKDFPassword:init_from_obj(obj)
    self.KDFPassword = obj.KDFPassword
end

function TKDFPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKDFPassword.group)
end

TKDFPassword.from_obj = TKDFPassword_from_obj

TKDFPassword.proto_property = {'KDFPassword'}

TKDFPassword.default = {''}

TKDFPassword.struct = {{name = 'KDFPassword', is_array = false, struct = nil}}

function TKDFPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'KDFPassword', self.KDFPassword, 'string', false, errs, need_convert)

    TKDFPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKDFPassword.proto_property, errs, need_convert)
    return self
end

function TKDFPassword:unpack(_)
    return self.KDFPassword
end

MHistoryPassword.KDFPassword = TKDFPassword

---@class MHistoryPassword.Password
---@field Password string
local TPassword = {}
TPassword.__index = TPassword
TPassword.group = {}

local function TPassword_from_obj(obj)
    return setmetatable(obj, TPassword)
end

function TPassword.new(Password)
    return TPassword_from_obj({Password = Password})
end
---@param obj MHistoryPassword.Password
function TPassword:init_from_obj(obj)
    self.Password = obj.Password
end

function TPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPassword.group)
end

TPassword.from_obj = TPassword_from_obj

TPassword.proto_property = {'Password'}

TPassword.default = {''}

TPassword.struct = {{name = 'Password', is_array = false, struct = nil}}

function TPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Password', self.Password, 'string', false, errs, need_convert)

    TPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPassword.proto_property, errs, need_convert)
    return self
end

function TPassword:unpack(_)
    return self.Password
end

MHistoryPassword.Password = TPassword

---@class MHistoryPassword.SequenceNumber
---@field SequenceNumber integer
local TSequenceNumber = {}
TSequenceNumber.__index = TSequenceNumber
TSequenceNumber.group = {}

local function TSequenceNumber_from_obj(obj)
    return setmetatable(obj, TSequenceNumber)
end

function TSequenceNumber.new(SequenceNumber)
    return TSequenceNumber_from_obj({SequenceNumber = SequenceNumber})
end
---@param obj MHistoryPassword.SequenceNumber
function TSequenceNumber:init_from_obj(obj)
    self.SequenceNumber = obj.SequenceNumber
end

function TSequenceNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSequenceNumber.group)
end

TSequenceNumber.from_obj = TSequenceNumber_from_obj

TSequenceNumber.proto_property = {'SequenceNumber'}

TSequenceNumber.default = {0}

TSequenceNumber.struct = {{name = 'SequenceNumber', is_array = false, struct = nil}}

function TSequenceNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SequenceNumber', self.SequenceNumber, 'uint8', false, errs, need_convert)

    TSequenceNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSequenceNumber.proto_property, errs, need_convert)
    return self
end

function TSequenceNumber:unpack(_)
    return self.SequenceNumber
end

MHistoryPassword.SequenceNumber = TSequenceNumber

---@class MHistoryPassword.AccountId
---@field AccountId integer
local TAccountId = {}
TAccountId.__index = TAccountId
TAccountId.group = {}

local function TAccountId_from_obj(obj)
    return setmetatable(obj, TAccountId)
end

function TAccountId.new(AccountId)
    return TAccountId_from_obj({AccountId = AccountId})
end
---@param obj MHistoryPassword.AccountId
function TAccountId:init_from_obj(obj)
    self.AccountId = obj.AccountId
end

function TAccountId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountId.group)
end

TAccountId.from_obj = TAccountId_from_obj

TAccountId.proto_property = {'AccountId'}

TAccountId.default = {0}

TAccountId.struct = {{name = 'AccountId', is_array = false, struct = nil}}

function TAccountId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'AccountId', self.AccountId, 'uint8', false, errs, need_convert)

    TAccountId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountId.proto_property, errs, need_convert)
    return self
end

function TAccountId:unpack(_)
    return self.AccountId
end

MHistoryPassword.AccountId = TAccountId

return MHistoryPassword
