-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Rule = {}

---@class Rule.TimeRule
---@field TimeRule string
local TTimeRule = {}
TTimeRule.__index = TTimeRule
TTimeRule.group = {}

local function TTimeRule_from_obj(obj)
    return setmetatable(obj, TTimeRule)
end

function TTimeRule.new(TimeRule)
    return TTimeRule_from_obj({TimeRule = TimeRule})
end
---@param obj Rule.TimeRule
function TTimeRule:init_from_obj(obj)
    self.TimeRule = obj.TimeRule
end

function TTimeRule:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeRule.group)
end

TTimeRule.from_obj = TTimeRule_from_obj

TTimeRule.proto_property = {'TimeRule'}

TTimeRule.default = {''}

TTimeRule.struct = {{name = 'TimeRule', is_array = false, struct = nil}}

function TTimeRule:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeRule', self.TimeRule, 'string', false, errs, need_convert)

    TTimeRule:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeRule.proto_property, errs, need_convert)
    return self
end

function TTimeRule:unpack(_)
    return self.TimeRule
end

Rule.TimeRule = TTimeRule

---@class Rule.MacRule
---@field MacRule string
local TMacRule = {}
TMacRule.__index = TMacRule
TMacRule.group = {}

local function TMacRule_from_obj(obj)
    return setmetatable(obj, TMacRule)
end

function TMacRule.new(MacRule)
    return TMacRule_from_obj({MacRule = MacRule})
end
---@param obj Rule.MacRule
function TMacRule:init_from_obj(obj)
    self.MacRule = obj.MacRule
end

function TMacRule:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMacRule.group)
end

TMacRule.from_obj = TMacRule_from_obj

TMacRule.proto_property = {'MacRule'}

TMacRule.default = {''}

TMacRule.struct = {{name = 'MacRule', is_array = false, struct = nil}}

function TMacRule:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MacRule', self.MacRule, 'string', false, errs, need_convert)

    TMacRule:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMacRule.proto_property, errs, need_convert)
    return self
end

function TMacRule:unpack(_)
    return self.MacRule
end

Rule.MacRule = TMacRule

---@class Rule.IpRule
---@field IpRule string
local TIpRule = {}
TIpRule.__index = TIpRule
TIpRule.group = {}

local function TIpRule_from_obj(obj)
    return setmetatable(obj, TIpRule)
end

function TIpRule.new(IpRule)
    return TIpRule_from_obj({IpRule = IpRule})
end
---@param obj Rule.IpRule
function TIpRule:init_from_obj(obj)
    self.IpRule = obj.IpRule
end

function TIpRule:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpRule.group)
end

TIpRule.from_obj = TIpRule_from_obj

TIpRule.proto_property = {'IpRule'}

TIpRule.default = {''}

TIpRule.struct = {{name = 'IpRule', is_array = false, struct = nil}}

function TIpRule:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpRule', self.IpRule, 'string', false, errs, need_convert)

    TIpRule:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpRule.proto_property, errs, need_convert)
    return self
end

function TIpRule:unpack(_)
    return self.IpRule
end

Rule.IpRule = TIpRule

---@class Rule.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or false})
end
---@param obj Rule.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or false
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

Rule.Enabled = TEnabled

Rule.interface = mdb.register_interface('bmc.kepler.AccountService.Rule', {
    Enabled = {'b', nil, false, false, false},
    IpRule = {'s', nil, false, nil, false},
    MacRule = {'s', nil, false, nil, false},
    TimeRule = {'s', nil, false, nil, false}
}, {}, {})

return Rule
