-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PasswordPolicy = {}

---@class PasswordPolicy.Pattern
---@field Pattern string
local TPattern = {}
TPattern.__index = TPattern
TPattern.group = {}

local function TPattern_from_obj(obj)
    return setmetatable(obj, TPattern)
end

function TPattern.new(Pattern)
    return TPattern_from_obj({Pattern = Pattern})
end
---@param obj PasswordPolicy.Pattern
function TPattern:init_from_obj(obj)
    self.Pattern = obj.Pattern
end

function TPattern:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPattern.group)
end

TPattern.from_obj = TPattern_from_obj

TPattern.proto_property = {'Pattern'}

TPattern.default = {''}

TPattern.struct = {{name = 'Pattern', is_array = false, struct = nil}}

function TPattern:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Pattern', self.Pattern, 'string', false, errs, need_convert)

    if self.Pattern ~= nil then
        validate.lens(prefix .. 'Pattern', self.Pattern, 0, 255, errs, need_convert)
    end

    TPattern:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPattern.proto_property, errs, need_convert)
    return self
end

function TPattern:unpack(_)
    return self.Pattern
end

PasswordPolicy.Pattern = TPattern

---@class PasswordPolicy.Policy
---@field Policy integer
local TPolicy = {}
TPolicy.__index = TPolicy
TPolicy.group = {}

local function TPolicy_from_obj(obj)
    return setmetatable(obj, TPolicy)
end

function TPolicy.new(Policy)
    return TPolicy_from_obj({Policy = Policy or 1})
end
---@param obj PasswordPolicy.Policy
function TPolicy:init_from_obj(obj)
    self.Policy = obj.Policy or 1
end

function TPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicy.group)
end

TPolicy.from_obj = TPolicy_from_obj

TPolicy.proto_property = {'Policy'}

TPolicy.default = {0}

TPolicy.struct = {{name = 'Policy', is_array = false, struct = nil}}

function TPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Policy', self.Policy, 'uint8', false, errs, need_convert)

    TPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicy.proto_property, errs, need_convert)
    return self
end

function TPolicy:unpack(_)
    return self.Policy
end

PasswordPolicy.Policy = TPolicy

PasswordPolicy.interface = mdb.register_interface('bmc.kepler.AccountService.PasswordPolicy', {
    Policy = {'y', {}, false, 1, false},
    Pattern = {'s', {}, false, nil, false}
}, {}, {})

return PasswordPolicy
