--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetInitialPasswordPromptEnable = {}

---@class AccountIpmiCmds.SetInitialPasswordPromptEnableReq
---@field ManufactureId integer
---@field UserId integer
---@field Reserved1 integer
---@field Reserved2 integer
---@field Length integer
---@field Data string
local TSetInitialPasswordPromptEnableReq = {}
TSetInitialPasswordPromptEnableReq.__index = TSetInitialPasswordPromptEnableReq
TSetInitialPasswordPromptEnableReq.group = {}

local function TSetInitialPasswordPromptEnableReq_from_obj(obj)
    return setmetatable(obj, TSetInitialPasswordPromptEnableReq)
end

function TSetInitialPasswordPromptEnableReq.new(ManufactureId, UserId, Reserved1, Reserved2, Length, Data)
    return TSetInitialPasswordPromptEnableReq_from_obj({
        ManufactureId = ManufactureId,
        UserId = UserId,
        Reserved1 = Reserved1,
        Reserved2 = Reserved2,
        Length = Length,
        Data = Data
    })
end
---@param obj AccountIpmiCmds.SetInitialPasswordPromptEnableReq
function TSetInitialPasswordPromptEnableReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
    self.Reserved2 = obj.Reserved2
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetInitialPasswordPromptEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInitialPasswordPromptEnableReq.group)
end

TSetInitialPasswordPromptEnableReq.from_obj = TSetInitialPasswordPromptEnableReq_from_obj

TSetInitialPasswordPromptEnableReq.proto_property = {
    'ManufactureId', 'UserId', 'Reserved1', 'Reserved2', 'Length', 'Data'
}

TSetInitialPasswordPromptEnableReq.default = {0, 0, 0, 0, 0, ''}

TSetInitialPasswordPromptEnableReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UserId', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}, {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetInitialPasswordPromptEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UserId', self.UserId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetInitialPasswordPromptEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetInitialPasswordPromptEnableReq.proto_property, errs, need_convert)
    return self
end

function TSetInitialPasswordPromptEnableReq:unpack(_)
    return self.ManufactureId, self.UserId, self.Reserved1, self.Reserved2, self.Length, self.Data
end

SetInitialPasswordPromptEnable.SetInitialPasswordPromptEnableReq = TSetInitialPasswordPromptEnableReq

---@class AccountIpmiCmds.SetInitialPasswordPromptEnableRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetInitialPasswordPromptEnableRsp = {}
TSetInitialPasswordPromptEnableRsp.__index = TSetInitialPasswordPromptEnableRsp
TSetInitialPasswordPromptEnableRsp.group = {}

local function TSetInitialPasswordPromptEnableRsp_from_obj(obj)
    return setmetatable(obj, TSetInitialPasswordPromptEnableRsp)
end

function TSetInitialPasswordPromptEnableRsp.new(CompletionCode, ManufactureId)
    return TSetInitialPasswordPromptEnableRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj AccountIpmiCmds.SetInitialPasswordPromptEnableRsp
function TSetInitialPasswordPromptEnableRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetInitialPasswordPromptEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInitialPasswordPromptEnableRsp.group)
end

TSetInitialPasswordPromptEnableRsp.from_obj = TSetInitialPasswordPromptEnableRsp_from_obj

TSetInitialPasswordPromptEnableRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetInitialPasswordPromptEnableRsp.default = {0, 0}

TSetInitialPasswordPromptEnableRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetInitialPasswordPromptEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetInitialPasswordPromptEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetInitialPasswordPromptEnableRsp.proto_property, errs, need_convert)
    return self
end

function TSetInitialPasswordPromptEnableRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetInitialPasswordPromptEnable.SetInitialPasswordPromptEnableRsp = TSetInitialPasswordPromptEnableRsp

return SetInitialPasswordPromptEnable
