#!/bin/bash
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

set -e

function add_len_to_hpm()
{
	file_len=$(stat -c%s $1)
	file_len_format=$(printf %08x $file_len)
	if [ 8 != $(echo $file_len_format | wc -L) ]
	then
		echo "$1 length is invalid, $file_len_format"
        exit 1
	fi
	echo -n $file_len_format >> $2
}

function check_prefix()
{
	PREFIX_PATH=$1
	file_list=$2
	#check prefix sign files
	if [ -f $PREFIX_PATH/cms.crl ];then
		echo "use prefixed cms.crl"
		cp $PREFIX_PATH/cms.crl cms.crl
	fi
	if [ -f $PREFIX_PATH/package.filelist ];then
		echo "use prefixed filelist as $file_list"
		cp $PREFIX_PATH/package.filelist $file_list
	fi
	if [ -f $PREFIX_PATH/package.filelist.cms ];then
		echo "use prefixed filelist.cms as $file_list.cms"
		cp $PREFIX_PATH/package.filelist.cms $file_list.cms
	fi
}

if [ $# -ne 2 ]; then
	echo "usage: $0 <sign_type> <file_path>"
	exit -1
fi

if [ ! -f $2 ]; then
	echo "file $2 not exist"
	exit -1
fi
orig_file=$2


if [ $1 == 1 ]
	then
	#handle outside hpm file
	file_list_temp=${orig_file##*/}
	file_list=${file_list_temp%.*}.filelist #get file name

	if echo "$file_list_temp" | grep _cb_flag_
	then
		# 获取board名
		board=$(echo "${file_list_temp}" | cut -d '.' -f 1| sed "s/_cb_flag//g"| sed "s/_0502.*//g"|sed "s/rootfs_//g"|sed "s/rw_//g")
		# 获取0502编码
		pre_0502_name=$(echo "$file_list_temp"|awk -F '_' '{print $NF}')
		cb_prd_name=$(cat ../../src/resource/board/${board}/${pre_0502_name}_cb_flag_archive.ini | grep -n CB_FLAG_TOSUPPORT_LP_NAME | awk -F '=' '{print $2}' | cut -d '-' -f 1|tr 'A-Z' 'a-z')
		file_list_temp=$(echo "${file_list_temp}"|sed "s/cb_flag_${board}_${pre_0502_name}/${cb_prd_name}/g")
	fi

	cat <<EOF > $file_list
Manifest Version: 1.0
Create By: Huawei Technology Inc.
Name: $file_list_temp
SHA256-Digest: $(sha256sum ${orig_file} | awk '{print $1}')
EOF
fi

if [ $1 == 2 ]
	then
	echo ${orig_file}
	hpm_temp=${orig_file}_temp
	file_list_temp=${orig_file##*/}
	file_list=${file_list_temp%.*}.filelist #get file name

	# 给语言包添加签名
	# 读取文件名，根据语言包名判断包的语言类型，用以定位预置秘钥，签名文件所在位置
	PACKAGE_NAME=${orig_file%.hpm}
	PREFIX_PATH=$PACKAGE_NAME
	echo "package name: $PACKAGE_NAME"
	if [[ $PACKAGE_NAME =~ "fr" ]];then
		PREFIX_PATH={$2}/prefix_language_fr/signature/
	fi
	if [[ $PACKAGE_NAME =~ "ja" ]];then
		PREFIX_PATH={$2}/prefix_language_ja/signature/
	fi
	if [[ $PACKAGE_NAME =~ "ru" ]];then
		PREFIX_PATH={$2}/prefix_language_ru/signature/
	fi

	echo "search for prefix: $PREFIX_PATH"
	check_prefix $PREFIX_PATH $file_list

	#add file num
	echo -n $(printf %08x 3) >> $hpm_temp
	#add file list id and length
	echo -n $(printf %08x 1) >> $hpm_temp
	add_len_to_hpm $file_list $hpm_temp

	#add cms file id and length
	echo -n $(printf %08x 2) >> $hpm_temp
	add_len_to_hpm $file_list.cms $hpm_temp

	#add crl file id and length
	echo -n $(printf %08x 3) >> $hpm_temp
	add_len_to_hpm cms.crl $hpm_temp

	#add cms related files
	cat $file_list >> $hpm_temp
	cat $file_list.cms >> $hpm_temp
	cat cms.crl >> $hpm_temp

	cat ${orig_file} >> $hpm_temp
	mv $hpm_temp ${orig_file}.signed
fi
