//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { describe, it, expect, vi, beforeEach } from 'vitest';
import { translate } from '@/utils/i18n-init.ts';

// Mock vue-i18n
vi.mock('vue-i18n', () => ({
  createI18n: vi.fn(() => ({
    global: {
      t: vi.fn(key => key),
    },
  })),
}));

// 简单的 JSON mock
vi.mock('@/assets/baseI18n/zh.json', () => ({}));
vi.mock('@/assets/baseI18n/en.json', () => ({}));
vi.mock('@/assets/baseI18n/ja.json', () => ({}));
vi.mock('@/assets/baseI18n/fr.json', () => ({}));
vi.mock('@/assets/baseI18n/ru.json', () => ({}));

vi.mock('@/assets/errorI18n/zh.json', () => ({}));
vi.mock('@/assets/errorI18n/en.json', () => ({}));
vi.mock('@/assets/errorI18n/ja.json', () => ({}));
vi.mock('@/assets/errorI18n/fr.json', () => ({}));
vi.mock('@/assets/errorI18n/ru.json', () => ({}));

describe('I18n 模块基础测试', () => {
  beforeEach(async () => {
    vi.clearAllMocks();
    // 清除模块缓存并重新导入
    vi.resetModules();
  });

  it('应该创建 I18n 实例', async () => {
    const { createI18n } = await import('vue-i18n');
    await import('@/utils/i18n-init.ts');
    expect(createI18n).toHaveBeenCalledTimes(1);
  });

  it('应该配置正确的选项', async () => {
    const { createI18n } = await import('vue-i18n');
    await import('@/utils/i18n-init.ts');
    const callArgs = createI18n.mock.calls[0][0];
    expect(callArgs.locale).toBe('en');
    expect(callArgs.globalInjection).toBe(true);
    expect(callArgs.legacy).toBe(false);
    expect(callArgs.messages).toBeDefined();
  });

  it('translate 函数应该工作', () => {
    const result = translate('test.key');
    expect(result).toBe('test.key');
  });

  it('应该导出 translate 函数', async () => {
    const module = await import('@/utils/i18n-init.ts');
    expect(typeof module.translate).toBe('function');
  });

  it('应该导出默认实例', async () => {
    const module = await import('@/utils/i18n-init.ts');
    expect(module.default).toBeDefined();
  });
});
