//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_BIOS, getSystemBootOptionsUrl, UI_REST_CPU, UI_REST_ENERGY_SAVING } from '@/api/api';
import $http from '@/utils/http-service';
import { reqPath } from '@/api/reqPath';

export function getBiosConfig(systemId?: string) {
  return new Promise((resolve, reject) => {
    // 如果提供了systemId参数，将其添加到请求URL中
    let url = UI_REST_BIOS;
    if (systemId) {
      url = getSystemBootOptionsUrl(systemId);
    }
    
    $http.get(url).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function saveBiosBoot(params: any, systemId?: string) {
  return new Promise((resolve, reject) => {
    let url = UI_REST_BIOS;
    if (systemId) {
      url = getSystemBootOptionsUrl(systemId);
    }
    $http.patch(url, params).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function getCPUData() {
  return new Promise((resolve, reject) => {
    $http.get(UI_REST_CPU).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function saveCPUState(params: any) {
  return new Promise((resolve, reject) => {
    $http.patch(UI_REST_CPU, params).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function getBiosSetting(systemId?: string): Promise<any> {
  return new Promise((resolve, reject) => {
    // 如果提供了systemId参数，将其添加到请求URL中
    let url = '/UI/Rest/System/Bios/Settings';
    if (systemId) {
      url = `/UI/Rest/Systems/${systemId}/Bios/Settings`;
    }
    
    $http.get(url).then(
      res => {
        resolve(res.data.Attributes);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function discardAllPending(systemId?: string): Promise<any> {
  return new Promise((resolve, reject) => {
    // 构建请求体，systemId为可选参数
    const requestBody: any = {};
    // 如果提供了systemId参数，将其添加到请求URL中
    let url = '/UI/Rest/System/Bios/RevokeSettings';
    if (systemId) {
      url = `/UI/Rest/Systems/${systemId}/Bios/RevokeSettings`;
    }
    
    $http.post(url, requestBody).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function importBiosWebConfig(params: any, systemId?: string): Promise<any> {
  return new Promise((resolve, reject) => {
    // 如果提供了systemId参数，将其添加到请求体中
    const requestBody = { ...params };

    // 如果提供了systemId参数，将其添加到请求URL中
    let url = '/UI/Rest/System/Bios/Settings';
    if (systemId) {
      url = `/UI/Rest/Systems/${systemId}/Bios/Settings`;
    }
    
    $http.patch(url, requestBody).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function resetFirmware(params: any): Promise<any> {
  return $http.post(reqPath.ibmc.resetFirmware, params);
}

export function exportBiosConfig(systemId?: string): Promise<any> {
  // 构建请求体，systemId为可选参数
  const requestBody: any = {};
  if (systemId) {
    requestBody.SystemId = Number(systemId);
  }
  
  return $http.post('/UI/Rest/System/Bios/ExportFirmware', requestBody);
}

export function getTask(url: string): Promise<any> {
  return $http.get(url);
}