//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { UI_REST_IMPORTCONFIG, UI_REST_IMPORT_PROGRESS } from '@/api/api';
import { reauthHandler } from '@/utils/sensitive';

export function queryProgress(url?: string) {
  return $http.get(url ?? UI_REST_IMPORT_PROGRESS);
}

export function importConfig(path: string, password: string) {
  const params = {
    Content: path,
    ReauthKey: window.btoa(password),
  };
  return reauthHandler(params).post(UI_REST_IMPORTCONFIG, params);
}
