//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { StatusBar } from './statusbar';
import { ToolBar } from './toolbar';
import { Display } from './display';
import { Mouse } from './mouse';
import { Keyboard } from './keyboard';
import { Communication } from './communication';

class KvmClient {
  public _language = null;
  public _display = null as any;
  public _mouse = null as any;
  public _keyboard = null as any;
  public _statusbar = null as any;
  public _toolbar = null as any;
  public _communication = null as any;
  public scope;
  public showMessage;
  public PSKEY = 44;
  constructor(scope: any, showMessage: any) {
    this.scope = scope;
    this.showMessage = showMessage;
    document.oncontextmenu = e => {
      return false;
    };
    document.addEventListener('keydown', e => {
      this._toolbar.setDefineKey(e);
      // tslint:disable-next-line: deprecation
      const keyCode = e.keyCode || e.which || e.charCode;
      if (keyCode !== 0x7b) {
        if (e?.preventDefault) {
          e.preventDefault();
        } else {
          // tslint:disable-next-line: deprecation
          (window.event as Event).returnValue = false;
        }
      }
    });
    document.addEventListener('keyup', e => {
      if (e && e.keyCode === this.PSKEY) {
        this._toolbar.setDefineKey(e);
      }
      // tslint:disable-next-line: deprecation
      const keyCode = e.keyCode || e.which || e.charCode;
      if (keyCode !== 0x7b) {
        if (e?.preventDefault) {
          e.preventDefault();
        } else {
          // tslint:disable-next-line: deprecation
          (window.event as Event).returnValue = false;
        }
      }
    });

    document.addEventListener('click', e => {
      this._toolbar.setDefineKey(e);
    });
  }

  run(
    language: any,
    ip: string,
    kvmPort: number,
    vmmPort: number,
    privilege: any,
    title: string,
    token: string,
    sessionId: string,
    host: number
  ): void {
    this._language = language;
    this._statusbar = new StatusBar(this, title);
    this._toolbar = new ToolBar(this, ip, vmmPort, privilege, language);
    this._display = new Display(this);
    this._mouse = new Mouse(this);
    this._keyboard = new Keyboard(this);
    this._communication = new Communication(this, ip, token, kvmPort, sessionId, host);
  }
}
export function openKvm(scope: any, showMessage: any) {
  const client = new KvmClient(scope, showMessage);
  const kvmParams = scope.kvmParams;
  client.run(
    kvmParams.local,
    kvmParams.IPA,
    kvmParams.port,
    kvmParams.vmmPort,
    kvmParams.privilege,
    kvmParams.title,
    kvmParams.token,
    kvmParams.sessionId,
    kvmParams.host
  );
}


