//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';
import { reauthHandler } from '@/utils/sensitive';

// 获取权限管理数据
export function getPermissionManagementData() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.userAndSecurity.permissionManagement)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 编辑权限管理数据
export function editPermissionManagementData(params: any) {
  return new Promise((resolve, reject) => {
    reauthHandler(params)
      .patch(reqPath.userAndSecurity.permissionManagement, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

export function addCustomRoleHandler(params: any): Promise<any> {
  return new Promise((resolve, reject) => {
    reauthHandler(params)
      .post(reqPath.userAndSecurity.permissionManagement, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

export function deleteCustomRoleHandler(id: number, params: any): Promise<any> {
  return new Promise((resolve, reject) => {
    reauthHandler(params)
      .delete(`${reqPath.userAndSecurity.permissionManagement}/${id}`, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
