//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { ILdapController } from '@/model/Users/ldap-interface';

export class LdapController implements ILdapController {
  public IPAddress: string = '';
  public Port: number = 0;
  public Domain: string = '';
  public BindDN: string = '';
  public Folder: string = '';

  constructor(controller?: { address: string; port: number; domain: string; bindDN: string; folder: string }) {
    if (controller) {
      this.IPAddress = controller.address;
      this.Port = controller.port;
      this.Domain = controller.domain;
      this.BindDN = controller.bindDN;
      this.Folder = controller.folder;
    }
  }
}
