//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { reqPath } from '@/api/reqPath';
import { IKrbSave } from '@/model/Users/kerberos-interface';
import { IKerberos, IGroupItem, IGroup } from '@/pages/User/models/type';
import { UserRoleList } from '@/pages/User/models/model';
import { UI_REST_FIRMWAREINVENTORY } from '@/api/api';
import { reauthHandler } from '@/utils/sensitive';

// 获取kerberos信息
export function getKerberos(): Promise<any> {
  return new Promise(resolve => {
    $http.get(reqPath.userAndSecurity.kerberos).then((res: any) => {
      const result: IKerberos = {
        KerberosEnabled: res.data.Enabled,
      };
      const groups: IGroupItem[] = [];
      const resData = res.data;
      resData?.Group?.Members.forEach((item: any) => {
        const loginRule: string[] = [...item.LoginRule];
        const role =
          item.RoleID === null || item.RoleID === UserRoleList.NOACCESS
            ? 'Common User'
            : item.RoleID;
        const groupItem: IGroupItem = {
          groupName: item.Name === null ? '' : item.Name,
          groupSID: item.SID === null ? '' : item.SID,
          groupRole: role,
          groupLoginInterface: item.LoginInterface,
          groupLoginRule: loginRule,
          groupDomain: item.Domain === null ? '' : item.Domain,
          memberId: item.ID,
        };
        groups.push(groupItem);
      });
      const group: IGroup = {
        id: resData.Id,
        kerberosPort: resData.Port === null ? '' : resData?.Port?.toString(),
        kerberosServerAddress: resData.IPAddress,
        name: resData.Name,
        realm: resData.Domain,
        uploadUrl: '',
        kerberosGroups: groups,
      };
      resolve([result, group]);
    });
  });
}
// 保存Kerberos基础信息
export function saveKerberos(param: IKrbSave, pwd: string): Promise<any> {
  return new Promise((resolve, reject) => {
    if (Object.keys(param).length === 0) {
      resolve('nochange');
    } else {
      if (pwd !== '') {
        param.ReauthKey = window.btoa(pwd);
      }
      reauthHandler(param)
        .patch(reqPath.userAndSecurity.kerberos, param)
        .then(res => {
          const item = {
            port: res.data.Port,
            realm: res.data.Domain,
            server: res.data.IPAddress,
          };
          resolve(item);
        })
        .catch(error => {
          reject(error);
        });
    }
  });
}
// Kerberos状态切换
export function switchKerberos(state: boolean) {
  return $http.patch(reqPath.userAndSecurity.kerberosState, { Enabled: state });
}

// 新增,编辑页面保存
export function saveGroup(params: any, password?: string): Promise<any> {
  return new Promise((resolve, reject) => {
    if (password !== undefined && password !== '') {
      params.ReauthKey = window.btoa(password);
    }
    return reauthHandler(params)
      .patch(reqPath.userAndSecurity.kerberos, params)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

// 上传Kerberos密钥表
export function uploadKrbFile(formData: FormData) {
  return $http.post(UI_REST_FIRMWAREINVENTORY, formData);
}

// 导入Kerberos密钥表
export function importKrbFile(fileName: string) {
  const data = { Content: `/tmp/web/${fileName}` };
  return $http.post(reqPath.userAndSecurity.ImportKeyTab, data);
}
