//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

import { IOptions } from '../storage-interface';
import { computeCapacity } from '../../utils/storage.utils';

export class AvailableCapacity {
  private label: string;
  public checked: boolean = false;
  private value: number;
  private unit: IOptions;
  private batyValue: number;

  // capacity构造参数是MB单位
  constructor(capacity: number) {
    const capacityObj = computeCapacity(capacity * 1024 * 1024);
    this.label = `${capacityObj.capacity}  ${capacityObj.unit.label}`;
    this.value = capacityObj.capacity;
    this.unit = capacityObj.unit;
    this.batyValue = capacity * 1024 * 1024;
  }

  get getValue() {
    return this.value;
  }

  get getLabel(): string {
    return this.label;
  }
  
  get getUnit() {
    return this.unit;
  }

  get getBatyValue() {
    return this.batyValue;
  }
}
