//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IFatherInter {
  name: string;
}
export interface IRadio extends IFatherInter {
  id: string | number | boolean;
  disable: boolean;
  label: string;
}
export interface IOptions extends IFatherInter {
  id: string | number | boolean;
  label: string;
  maxCapacity?: number;
}
export interface ICheckBok extends IFatherInter {
  id: string;
  label: string;
  checked: boolean;
  disable: boolean;
}
export interface ISwitch extends IFatherInter {
  id: string | number | boolean;
  label: string;
  state: boolean;
}
export interface IValue extends IFatherInter {
  label: string;
  value: string | number | boolean | [];
}
export interface IHealthState extends IFatherInter {
  key: string | number | boolean;
  label: string;
  className: string;
}
export interface IWriteCachePolicy {
  ConfiguredDrive: string;
  HBADrive: string;
  UnconfiguredDrive: string;
}

export enum Store {
  JBOD = 'JBOD',
  Online = 'Online',
  Offline = 'Offline',
  UnconfiguredGood = 'UnconfiguredGood',
  UnconfiguredBad = 'UnconfiguredBad'
}

export enum RaidType {
  PMC = 'PMC',
  BRCM = 'BRCM',
  ARIES = 'ARIES',
  HBA = 'HBA'
}
 
export interface IFromSet {
  lineHeight: string;
  fieldVerticalAlign: string;
  formType: string;
}


export interface IChildData {
  volumeSupport: boolean;
  oobSupport: boolean;
  maxSize: number;
  minSize: number;
  readPolicyConfig: boolean;
  writePolicyConfig: boolean;
  IOPolicyConfig: boolean;
  drivePolicyConfig: boolean;
  accessPolicyConfig: boolean;
}

export interface IVolumnDisabled {
  twoCache: boolean;
  readPolicyConfig: boolean;
  writePolicyConfig: boolean;
  iOPolicyConfig: boolean;
  drivePolicyConfig: boolean;
  accessPolicyConfig: boolean;
  isSSCD: boolean;
}

export interface IDriverEditData {
  indicatorLED: ISwitch;
  hotspareType: IRadio | null;
  firmwareStatus: IOptions | null;
  spareforLogicalDrive: IOptions | IOptions[];
  patrolState?: IOptions;
  bootPriority?: IOptions;
  bootEnabled: IStorageRadio;
}
export interface IVolumePolicyData {
  name: string | null;
  createCacheCadeFlag: boolean | null;
  optimumIOSizeBytes: IOptions | null;
  defaultReadPolicy: IOptions | null;
  defaultWritePolicy: IOptions | null;
  defaultCachePolicy: IOptions | null;
  driveCachePolicy: IOptions | null;
  accessPolicy: IOptions | null;
  initializationMode: IOptions | null;
  cacheLineSize?: IOptions | null;
  associationLogical?: IOptions | null;
  accelerationMethod?: IOptions | null;
}

export interface IRaidEditData {
  jBODState: boolean;
  copyBackState: boolean;
  smarterCopyBackState: boolean;
  mode: IOptions | null;
  bootDevice1?: IOptions | null;
  bootDevice2?: IOptions | null;
  writeCacheType?: IOptions | null;
  writeCachePolicy?: IOptions | null;
  noBatteryWriteCacheEnabled?: boolean | null;
  readCachePercent?: number | null;
}

export interface IVolumeEditData {
  name: string | null;
  bootEnabled: IStorageRadio | null;
  sSDCachingEnabled: IStorageRadio | null;
  driveCachePolicy: IOptions | null;
  accessPolicy: IOptions | null;
  bGIEnabled: IOptions | null;
  defaultCachePolicy: IOptions | null;
  defaultWritePolicy: IOptions | null;
  defaultReadPolicy: IOptions | null;
  optimumIOSizeBytes: IOptions | null;
  accelerationMethod: IOptions | null;
  capacity: string | null;
  capacityUnit: IOptions | null;
  bootPriority: IOptions | null;
}

export interface IVolumeMembersData {
  volumeRaidLevel: IOptions | null;
  spanNumber: number | null;
  capacityMBytes: number | null;
  drives: number[] | null;
}

export interface ISelect {
  disable: boolean;
  options: IOptions[];
}

export interface IDriveBox extends ICheckBok {
  driveId: string;
  isDisable: boolean;
  capacity: number;
  related: any;
  mediaType: string;
  firmware: string;
}


export interface IRaidButton {
  isShow: boolean;
  button: IButton[];
}

export interface IButton {
  id: string;
  label: string;
  isShow: boolean;
  disable: boolean;
}

export interface ISmartSwitch extends ISwitch {
  disable: boolean;
}

export interface ICapacity {
  value: number | null;
  unit: IOptions;
  options: IOptions[];
  batyValue: number | null;
  oldValue?: number | null;
}

export interface ISpanNum {
  value: number | null;
  disable: boolean;
  rang: ISpanCount | null;
}

export interface IStorageRadio extends IRadio {
  attrName: string;
}

export interface ISpanCount {
  min: number;
  max: number;
}

export interface TreeNode {
  /**
   * 节点展示内容
   */
  label?: string;
  /**
   * 控制节点是否展开
   */
  expanded?: boolean;
  /**
   * 节点选中状态（多选场景）：选中，未选中，半选 true | false | 'indeterminate'
   */
  checked?: boolean | string;
  /**
   * 节点展开时的字体图标：节点图标的样式类名称
   */
  expandIcon?: string;
  /**
   * 节点收起时的字体图标：节点图标的样式类名称
   */
  collapseIcon?: string;
  /**
   * 控制多选的节点checkbox是否灰化
   */
  disabled?: boolean;
  /**
   * 子节点字段，一旦设置children: []，则认为该节点非叶子节点
   */
  children?: Array<TreeNode>;
  /**
   * 允许有多余的属性字段
   */
  [propName: string]: any;
}
const interNameArr = [
  'IOptions',
  'IHealthState',
  'IRadio',
  'ISwitch',
  'ICheckBok',
  'IValue',
  'IDetailInfo',
];

const classNameArr = [
  'IHealthState',
];
export { interNameArr, classNameArr };