//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const data = {
  data: {
    RaidControllers: [
      {
        VolumeSupported: true,
        Name: 'RAID Card1',
        Volumes: [
          {
            Name: 'Logical Drive 0',
            HotSpares: null,
            Drives: [
              {
                Name: 'Disk1',
                CryptoEraseSupported: false,
                Drives_ID: 'HDDPlaneDisk1',
              },
            ],
            VolumeRaidLevel: 'RAID0',
            Spans: null,
            Volumes_ID: 'LogicalDrive0',
          },
          {
            Name: 'Logical Drive 1',
            HotSpares: null,
            Drives: [
              {
                Name: 'Disk2',
                CryptoEraseSupported: false,
                Drives_ID: 'HDDPlaneDisk2',
              },
            ],
            VolumeRaidLevel: 'RAID0',
            Spans: null,
            Volumes_ID: 'LogicalDrive1',
          },
        ],
        Mode: 'RAID',
        RaidController_ID: 'RAIDStorage0',
        Drives: [],
      },
    ],
  },
  RAIDStorage0: {
    ID: 'RAIDStorage0',
    FaultDetails: null,
    SupportedRAIDTypes: ['RAID0', 'RAID1', 'RAID10'],
    SupportedModes: ['RAID'],
    Mode: 'RAID',
    MaintainPDFailHistory: true,
    MemorySizeMiB: 0,
    AccessPolicy: {
      SupportedPolicy: ['ReadWrite', 'ReadOnly', 'Blocked'],
      Configurable: true,
    },
    SupportedDeviceProtocols: 'SAS',
    BBU: null,
    DriverInfo: {
      DriverVersion: '07.709.08.00',
      DriverName: 'megaraid_sas',
    },
    CopyBackState: true,
    SmarterCopyBackState: false,
    FirmwareVersion: '5.030.01-1330',
    WritePolicy: {
      SupportedPolicy: ['WriteThrough', 'WriteBackWithBBU', 'WriteBack'],
      Configurable: false,
    },
    Health: 'OK',
    JBODState: true,
    Name: 'SAS3416',
    ReadPolicy: {
      SupportedPolicy: ['NoReadAhead', 'ReadAhead'],
      Configurable: false,
    },
    CachePolicy: {
      SupportedPolicy: ['CachedIO', 'DirectIO'],
      Configurable: false,
    },
    Drives: [
      {
        ID: 1,
        Name: 'Disk1',
        VolumeRaidLevel: 'RAID0',
        TotalFreeSpaceMiB: 0,
        FreeSpaceMiBPerDrive: 0,
        MediaType: 'HDD',
        FirmwareStatus: 'Online',
        FreeBlocksSpaceMiB: [-1],
        CapacityBytes: 899627876352,
        DriveID: 'HDDPlaneDisk1',
        Members: ['HDDPlaneDisk1'],
        NumDrivePerSpan: 1,
        IsEPD: false,
      },
      {
        ID: 2,
        Name: 'Disk2',
        VolumeRaidLevel: 'RAID0',
        TotalFreeSpaceMiB: 0,
        FreeSpaceMiBPerDrive: 0,
        MediaType: 'HDD',
        FirmwareStatus: 'Online',
        FreeBlocksSpaceMiB: [-1],
        CapacityBytes: 899627876352,
        DriveID: 'HDDPlaneDisk2',
        Members: ['HDDPlaneDisk2'],
        NumDrivePerSpan: 1,
        IsEPD: false,
      },
    ],
    DriveCachePolicy: {
      SupportedPolicy: ['Unchanged', 'Enabled', 'Disabled'],
      Configurable: true,
    },
    CachePinnedState: false,
    MinStripeSizeBytes: 65536,
    VolumeSupported: true,
    MaxStripeSizeBytes: 65536,
    SASAddress: '5a4be2bc62ca7000',
    Manufacturer: 'LSI',
    Type: 'SAS3416iMR',
    ConfigurationVersion: '5.0300.03-0043',
    SpeedGbps: 12,
    OOBSupport: true,
  },
};
