//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { IRaidEditData, RaidEditModel, StorageTree } from '../../../models';
import { deleteEmptyProperty } from '../../../utils';

export class RaidEditService {
  constructor() { }

  private save(dataCopy: any, data: IRaidEditData) {
    const obj = {};
    for (const attr in data) {
      if (JSON.stringify(data[attr]) !== JSON.stringify(dataCopy[attr])) {
        const key: string = attr.substring(0, 1).toUpperCase() + attr.substring(1);
        let value: any = null;
        if (data[attr] && typeof data[attr] === 'object') {
          value = data[attr].id;
        } else {
          value = data[attr];
        }
        obj[key] = value;
      }
    }
    deleteEmptyProperty(obj);
    return (obj && JSON.stringify(obj) !== '{}') ? obj : null;
  }

  public updateEditData(url: string, param: any) {
    // 启动盘配置
    if (param && (param.BootDevice1 || param.BootDevice2)) {
      const device1 = RaidEditModel.getInstance().getSelectData.bootDevice1;
      const device2 = RaidEditModel.getInstance().getSelectData.bootDevice2;
      param.BootDevice1 = param.BootDevice1?.replace('Logical Drive ', 'Volume');
      param.BootDevice2 = param.BootDevice2?.replace('Logical Drive ', 'Volume');
      param.BootDevices = [param.BootDevice1 || device1?.label || 'None', param.BootDevice2 || device2?.label || 'None'];
      delete param.BootDevice1;
      delete param.BootDevice2;
    }

    // 硬盘写缓存策略配置
    if (param.WriteCacheType || param.WriteCachePolicy) {
      const type = param.WriteCacheType || RaidEditModel.getInstance().getSelectData.writeCacheType?.id;
      const policy = param.WriteCachePolicy || RaidEditModel.getInstance().getSelectData.writeCachePolicy?.id;
      param.WriteCachePolicy = {};
      param.WriteCachePolicy[type as string] = policy;
      delete param.WriteCacheType;
    }
    
    if (param.ConsisCheckInfo && Object.keys(param.ConsisCheckInfo).length === 0) {
      delete param.ConsisCheckInfo;
    }
    return $http.patch(url, param);
  }

  public reset() {
    const node = StorageTree.getInstance().getCheckedNode;
    const url = `/UI/Rest/System/Storage/${node?.id}/RestoreDefaultSettings`;
    return $http.post(url, {});
  }

  // 	导入Foreign配置
  public foreignConfig() {
    const node = StorageTree.getInstance().getCheckedNode;
    const url = `/UI/Rest/System/Storage/${node?.id}/ImportForeignConfig`;
    return $http.post(url, {});
  }

  // 一键收集
  public oneKeyCollect(urlString: string) {
    const url = `${urlString}/DumpControllerLog`;
    return $http.post(url, {});
  }
}
