//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { traduction } from '@/utils/language';

import { IDriverEditData, StorageTree, DriverEditModel } from '../../../models';
import { deleteEmptyProperty } from '../../../utils';
import $http from '@/utils/http-service';

export function getLoginOptions(node: any) {
  const storageTree = StorageTree.getInstance().getFoliages;
  const parents: any[] = [];
  const parentIds = node.labelId.split('_');
  parentIds.pop();
  const getNode = (arr: any, id: string): void => {
    if (arr && arr.length > 0) {
      for (let i = 0; i < arr.length; i++) {
        if (arr[i].id === id) {
          parents.push(arr[i]);
        }
        if (arr[i].children) {
          getNode(arr[i].children, id);
        }
      }
    }
  };
  for (let i = 0; i < parentIds.length; i++) {
    getNode(storageTree, parentIds[i]);
  }
  const raidNode: any = parents[0];
  const options: any = [];
  const logicSelect: any[] = [];
  raidNode?.children.forEach((children: any) => {
    if (children.componentName && children.componentName === 'VolumeNode') {
      const volumeObj = children;
      const hotSpareList = volumeObj.children?.filter((item: any) => item.className === 'hotSpareClass') || [];
      if (volumeObj.getRaidLevel !== 'RAID0') {
        const option = { name: 'IOptions', id: children.url, label: children.label, disabled: false };
        options.push(option);
        if (volumeObj.getDriverNode?.includes(node.label)) {
          logicSelect.push(option);
        } else if (hotSpareList.length > 0) {
          hotSpareList[0].children.forEach((item: any) => {
            if (item?.label === node.label) {
              logicSelect.push(option);
            }
          });
        } else {}
      }
    }
  });
  if (options.length === 0) {
    options.push({ name: 'IOptions', id: 'noData', label: traduction('COMMON_NO_DATA') });
    logicSelect.push({ name: 'IOptions', id: 'noData', label: traduction('COMMON_NO_DATA') });
  }
  return { options, logicSelect };
}


export function save(dataCopy: any, data: IDriverEditData) {
  const obj = {};
  for (const attr in data) {
    if (JSON.stringify(data[attr]) !== JSON.stringify(dataCopy[attr])) {
      const key: string = attr.substring(0, 1).toUpperCase() + attr.substring(1);
      let value: any = null;
      if (data[attr]?.name) {
        value = data[attr].id;
      } else {
        value = data[attr];
      }
      obj[key] = value;
    }
  }
  deleteEmptyProperty(obj);
  return (obj && JSON.stringify(obj) !== '{}') ? obj : null;
}
export function updateEditData(url: string) {
  const node = StorageTree.getInstance().getCheckedNode;
  const param = save(DriverEditModel.getInstance().getOriginData, DriverEditModel.getInstance().getSelectData) as any;
  // 当设置热备，不能下发固件状态
  if (Object.prototype.hasOwnProperty.call(param, 'HotspareType') &&
    Object.prototype.hasOwnProperty.call(param, 'FirmwareStatus')) {
    delete param.FirmwareStatus;
  }
  // 如果下发局部热备，一定要下发逻辑盘选项
  if (Object.prototype.hasOwnProperty.call(param, 'HotspareType') && param.HotspareType === 'Dedicated') {
    param.SpareforLogicalDrive = (DriverEditModel.getInstance().getSelectData.spareforLogicalDrive as any).id;
  }
  return $http.patch(url, param);
}


