//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

import $http from '@/utils/http-service';

export function getThreshold(): Promise<number | null> {
  return $http.get('/UI/Rest/System/Storage/Settings').then((res) => res.data.SSDMediaLifeLeftPercentThreshold);
}

export async function setThreshold(threshold: number): Promise<void> {
  await $http.patch('/UI/Rest/System/Storage/Settings', {
    ['SSDMediaLifeLeftPercentThreshold']: threshold,
  });
}