//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface ISpeedAdjustmentMode {
  id: string;
  label: string;
  content: string;
  isSelect: boolean;
  isShow: boolean;
  tip?: string;
}
export interface IFanLabel {
  model: string;
  speed: string;
  rate: string;
  partNumber: string;
}

export interface IValidationTip {
  tip: string;
  tipPosition: string;
}

export interface ITab {
  title: string;
  id: string;
  active: boolean;
}

export interface ISensorData {
  XScope: number;
  YScope: number;
  Sensors: ISensor[];
  Temperatures: ISensor[];
}

export interface ISensor {
  Index?: number;
  Name: string;
  ReadingValue: number;
  CoordinateX: number;
  CoordinateY: number;
  UpperThreshold: any[];
  LowerThreshold: any[];
  Status: string;
}

export interface ISensorOptions {
  data: object;
  max: number | null;
  min: number | null;
  step: number;
  degree: number;
}

export interface INodeData {
  data: number[];
}

export interface IFloatXY {
  x: number;
  y: number;
}

export interface IAssociatedNodes {
  length: number;
}
