//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IFanInfo {
  id: string;
  fanName: string;
  fanModel: string;
  fanSpeed: string;
  fanRate: string;
  fanPartNumber: string;
  presence: string;
  expectedSpeedRatio?: number | string;
  fanDutyCycle: string;
}

export interface IIntelSpeedAdjust {
  fanSmartCoolingModeText: string;
  fanSpeedCustom: boolean;
  cpuTargetTemperatureCelsius: number;
  npuHbmTargetTemperatureCelsius: number;
  npuAiCoreTargetTemperatureCelsius: number;
  outletTargetTemperatureCelsius: number;
  temperatureRangeCelsius: number[];
  fanSpeedPercents: number[];
  fanSmartCoolingMode: string;
  coolingMedium: string;
  minCPUTargetTemperatureCelsius: number;
  maxCPUTargetTemperatureCelsius: number;
  minHdmTargetTemperatureCelsius: number;
  maxHdmTargetTemperatureCelsius: number;
  minAiTargetTemperatureCelsius: number;
  maxAiTargetTemperatureCelsius: number;
  minOutletTargetTemperatureCelsius: number;
  maxOutletTargetTemperatureCelsius: number;
  minTemperatureRangeCelsius: number;
  maxTemperatureRangeCelsius: number;
  minFanSpeedPercents: number;
  maxFanSpeedPercents: number;
  modelPredictiveControlEnabled: boolean;
  expectedSpeedRatio?: number | string;
}

export interface IAirInletTemperature {
  inletTemperature: number | string;
  time: string[];
  inletTempCelsius: number[];
}

export interface ISpeedAdjustmentMode {
  id: string;
  label: string;
  content: string;
  isSelect: boolean;
  isShow: boolean;
  tip?: string;
}

export interface IFanLabel {
  model: string;
  speed: string;
  rate: string;
  partNumber: string;
}

export interface IValidationTip {
  tip: string;
  tipPosition: string;
}

export interface ICustomSpeed {
  id: string;
  tip: string;
  errorTip: string;
  tipPosition: string;
  max: number;
  min: number;
  value: number;
  show: boolean;
  label: string;
  hasError: boolean;
  showTips: boolean;
}

export interface IPumpInfo {
  id: string;
  pumpName: string;
  pumpSpeedRPM: string;
  pumpSpeedPercent: string;
  pumpPartNumber: string;
  presence: string;
}

export const enum MODE_INDEX {
  ENERGY_SAVING = 0,
  LOW_NOISE = 1,
  HIGH_PERFORMANCE = 2,
  LIQUID_COOLING = 3,
  CUSTOM = 4
}