//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';
import { mapReauth } from '@/utils/sensitive';

// 获取SNMP数据
export function getSnmpData() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.snmp)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 编辑SNMP数据
export function editSnmpData(params: any) {
  return new Promise((resolve, reject) => {
    const roPath = params.SNMPv1v2?.ROCommunityName ? [['SNMPv1v2', 'ROCommunityName']] : [];
    const rwPath = params.SNMPv1v2?.RWCommunityName ? [['SNMPv1v2', 'RWCommunityName']] : [];
    mapReauth([...roPath, ...rwPath])(params)
      .patch(reqPath.snmp, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
