//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';
import { reauthHandler } from '@/utils/sensitive';

// 获取SP管理数据
export function getSpData() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.manager.sp.SPData)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 编辑
export function editSpData(params: any) {
  return new Promise((resolve, reject) => {
    $http
      .patch(reqPath.manager.sp.SPData, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 创建SP恢复出厂设置配置
export function SPRestore(params: any) {
  return new Promise((resolve, reject) => {
    reauthHandler(params)
      .post(reqPath.manager.sp.SPRestore, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 查询SP恢复出厂设置配置
export function getSPRestore() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.manager.sp.SPRestore)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 删除SP恢复出厂设置配置
export function deleteSPRestore() {
  return new Promise((resolve, reject) => {
    $http
      .delete(reqPath.manager.sp.SPRestore)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 获取SP恢复出厂设置配置结果
export function getResult() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.manager.sp.result)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
// 获取sp任务信息
export function getTaskData(type: string): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(`/UI/Rest/JobService/Jobs?JobType=${type}`)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
interface jobParamsT {
  JobType?: string;
  JobState?: string;
  InitialStartTime?: string;
  Payload?: any;
  JobId?: string;
}
// 创建sp任务
export function createJob(jobParams: jobParamsT): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .post('/UI/Rest/JobService/CreateJob', {
        JobType: jobParams.JobType,
        InitialStartTime: jobParams.InitialStartTime,
        Payload: jobParams.Payload,
      })
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
export function cancelJob(jobParams: jobParamsT): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .post('/UI/Rest/JobService/UpdateJob', {
        JobId: jobParams.JobId,
        JobState: jobParams.JobState,
      })
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
// 更新sp任务
export function updateJob(jobParams: jobParamsT): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .post('/UI/Rest/JobService/UpdateJob', {
        JobId: jobParams.JobId,
        JobType: jobParams.JobType,
        InitialStartTime: jobParams.InitialStartTime,
        Payload: jobParams.Payload,
      })
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 删除sp任务
export function deleteJobs(jobIds: string[]): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .post('/UI/Rest/JobService/DeleteJobs', {
        JobIds: jobIds,
      })
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
// 获取os部署模板
export function getTemplate(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get('/UI/Rest/BMCSettings/SPService/TaskTemplates?Type=SPOSInstall')
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
