//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IZreo {
  key: string;
  label: string;
}

export interface IParam {
  content: string;
  value: string;
  relatedContent?: string;
}

export interface IPolling {
  id: number;
  label: string;
}

export interface IRadio {
  key: string;
  id: string;
  disable: boolean;
}

export interface INtpModal {
  server: INtp;
  serverPreferred: INtp;
  serverAlternate: INtp;
}

export interface INtp {
  id: string;
  label: string;
  value: string;
  count: number;
  tip: string;
}

export interface ITimeArea {
  timeZoneConfigurable: boolean;
  dateTimeLocalOffset: string;
  timeZone: string;
}

export interface IDHCPData {
  dhcpv4Enable: boolean;
  dhcpv6Enable: boolean;
  alternateServer: string;
  extraServer: string;
  preferredServer: string;
  serverCount: number;
  addressMode: string;
}

export interface INtpData {
  authEnabled: boolean;
  enabled: boolean;
  keyStatus: number;
  maxPollingInterval: number;
  minPollingInterval: number;
}
