//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export function parsingInfo(mebers: object[]): object[] {
  let tempS: any[] = [];
  mebers.forEach(item => {
    const targetData = parsingNPUInfo(item);
    if (JSON.stringify(targetData) !== '{}') {
      tempS.push(targetData);
    }
  });
  return tempS;
}

function parsingNPUInfo(npu: any) {
  const npuLogProgressUrl: string | any = sessionStorage.getItem('npuLogProgressUrl');
  let npuLogProgressItem: any = {};
  const str = sessionStorage.getItem('npuLogProgressItem');
  if (str) {
    npuLogProgressItem = JSON.parse(str);
  }

  let temp = {
    fileName: 'npu.tar.gz',
    status: true,
    title: '',
    id: 'NPU',
    down: false,
    showProgress: false,
    isCollectingOk: false,
    isCollectingErr: false,
    percent: '0%',
    percentValue: 0,
    progressResult: '',
  };
  if (npu.State !== 'Absent') {
    temp.fileName = 'npu.tar.gz';
    temp.title = npu.slotNumber ? `NPU Card ${npu.slotNumber}` : npu.Name;
    temp.id = 'NPU';
    temp.status = true;
    temp.down = false;
    temp.showProgress = false;
    temp.isCollectingOk = false;
    temp.isCollectingErr = false;
    if (npuLogProgressItem && Array.isArray(npuLogProgressItem)) {
      const npuIndex = npuLogProgressItem.findIndex((item) => item.title === temp?.title);
      if (npuIndex > -1) {
      temp = npuLogProgressItem[npuIndex];
      }
    }
    return temp;
  }
  return {};
}
