//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_GENERALDOWNLOAD } from '@/api/api';
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';

// 获取PCLe、黑匣子功能、系统串口数据记录功能 数据
export function systemDiagnostic() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.maintance.systemlog.systemDiagnostic)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 获取处理器集合数据
export function processor() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.maintance.systemlog.processor)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 获取处理器集合数据
export function getPCIeCard(): any {
  return new Promise((resolve, reject) => {
    $http
      .get('/UI/Rest/System/Boards/PCIeCard')
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 修改PCLe、黑匣子功能、系统串口数据记录功能 数据
export function editSystemDiagnostic(params: any) {
  return new Promise((resolve, reject) => {
    $http
      .patch(reqPath.maintance.systemlog.systemDiagnostic, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 获取下载路径下载
export function getDownloadUrl(url: string, params: any) {
  return new Promise((resolve, reject) => {
    $http
      .post(url, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 获取下载进度
export function getDownloadProgress(url: string) {
  return new Promise((resolve, reject) => {
    $http
      .get(url)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 下载
export function downloadData(fileName: string) {
  const data = {
    Path: `/tmp/${fileName}`,
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}
