//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import useStore from '@/stores';
import $http from '@/utils/http-service';
import { traduction } from '@/utils/language';
import { mapReauth } from '@/utils/sensitive';

export function getSyslogInfo() {
  return $http.get('/UI/Rest/Maintenance/SyslogNotification');
}
// syslog保存
export function sysLogSave(params: any) {
  return $http.patch('/UI/Rest/Maintenance/SyslogNotification', params);
}
// 导入本地根证书
export function imporCustomCertificate(params: any, headers: any) {
  return $http.post(
    '/UI/Rest/Maintenance/SyslogNotification/ImportClientCertificate',
    params,
    headers,
  );
}
// 列表测试接口
export function sysLogSendTest(params: { ID: number }) {
  return $http.post('/UI/Rest/Maintenance/TestSyslogNotification', params);
}

export function getEmailInfo() {
  return $http.get('/UI/Rest/Maintenance/EmailNotification');
}
export function emailSaveFun(params: any) {
  const senderPassPath = params.EmailInfo?.SenderPassword ? [['EmailInfo', 'SenderPassword']] : [];
  return mapReauth(senderPassPath)(params).patch(
    '/UI/Rest/Maintenance/EmailNotification',
    params,
  );
}
export function emailSendTest(params: { ID: number }) {
  return $http.post(
    '/UI/Rest/Maintenance/TestEmailNotification',
    params,
  );
}

// 获取trap信息
export function getTrapInfoFun() {
  return $http.get('/UI/Rest/Maintenance/TrapNotification');
}
export function trapSave(params: any) {
  const comuNamePath = params.CommunityName ? ['CommunityName'] : [];
  return mapReauth(comuNamePath)(params).patch(
    '/UI/Rest/Maintenance/TrapNotification',
    params,
  );
}
export function trapSendTest(params: any) {
  return $http.post(
    '/UI/Rest/Maintenance/TestTrapNotification',
    params,
  );
}
// 获取是否开启校验
export function getPwdCode() {
  return $http.get('/UI/Rest/AccessMgnt/AdvancedSecurity');
}

export function alertMessage(params: { type: string; label: string }): any {
  return useStore().state.event.setEventState({
    type: 'alertMessage',
    value: { type: params.type, message: traduction(params.label) },
  });
}

export function getSyslogDBInfo() {
  return $http.get('/UI/Rest/Maintenance/RemoteSyslog');
}

// syslog保存
export function sysLogDBSave(params: any) {
  return $http.patch('/UI/Rest/Maintenance/RemoteSyslog', params);
}

// 列表测试接口
export function sysLogDBSendTest(params: { ID: number; LogType: string }) {
  return $http.post('/UI/Rest/Maintenance/TestRemoteSyslog', params);
}