//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export enum LANG {
  zh = 'zh-CN',
  en = 'en-US',
  ja = 'ja-JA',
  fr = 'fr-FR',
  ru = 'ru-RU'
}

export enum MaxLength {
  user = 16,
  min = 20,
  max = 255
}

export enum DEFAULT_DATA {
  noDataStr = '--'
}

export enum platform {
  ARM = 'Arm'
}

export enum monitorType {
  cpu = 'cpu',
  hardDisk = 'hardDisk',
  memory = 'memory',
  network = 'network'
}

// 0,1为非免密登录，2,3为免密登录, -1: 初始状态
export enum LOGIN_TYPE {
  undetermined = -1,
  common = 0,
  sso = 1,
  twoFactor = 2,
  krbsso = 3
}

// 二次密码认证的错误ID
export enum SecondAuthorityFail {
  EMPTY = '',
  AUTHORIZATIONFAILED = 'AuthorizationFailed',
  REAUTHFAILED = 'ReauthFailed',
  USERLOCKED = 'UserLocked'
}

// 路由跳转错误原因列表
export enum RouterChangeReason {
  invalid = 'invalid',
  notLogin = 'notLogin',
  noPermission = 'noPermission'
}

// 角色权限对应关系
export enum UserPrivil {
  query = 'QueryEnabled',
  baseConfig = 'BasicConfigEnabled',
  configSelf = 'ConfigureSelfEnabled',
  userConfig = 'UserConfigEnabled',
  remoteControl = 'RemoteControlEnabled',
  securityConfig = 'SecurityConfigEnabled',
  powerControl = 'PowerControlEnabled',
  vmm = 'VMMEnabled',
  diagnosis = 'DiagnosisEnabled',
  diagnosiss = 'DiagnosisEnabledsss'
}

export enum MainMenuId {
  Home = 'navHome',
  System = 'navSystemManager',
  Maintance = 'navMaintance',
  User = 'navUsersManager',
  Service = 'navServiceManager',
  Manager = 'navIbmcManager'
}

export enum SysId {
  Info = 'leftSysInfo',
  Monitor = 'leftSysMonitor',
  Storage = 'leftSysStorage',
  Power = 'leftSysPower',
  Fans = 'leftSysFans',
  Bios = 'leftSysBios',
  Partity = 'leftSysPartity'
}

export enum MaintanceId {
  Event = 'leftMainEvent',
  Report = 'leftMainReport',
  Fdm = 'leftMainFdm',
  Video = 'leftMainVideo',
  SysLog = 'leftMainSysLog',
  IbmcLog = 'leftMainIbmcLog',
  Note = 'leftMainNote',
  Asset = 'leftAssetMaintance',
  Data = 'leftMainTelemetryData',
}

export enum UserId {
  LocalUsers = 'leftUserLocalUsers',
  Ldap = 'leftUserLdap',
  Kerberos = 'leftUserKerberos',
  TwoFactor = 'leftUserTwoFactor',
  Online = 'leftUserOnline',
  Security = 'leftUserSecurity',
  Certificate = 'leftUserCertificate',
  TrustedCompute = 'leftTrustedCompute',
}

export enum ServiceId {
  Port = 'leftPortService',
  Web = 'leftWebService',
  Kvm = 'leftKvmService',
  Vmm = 'leftVmmService',
  Vnc = 'leftVncService',
  Snmp = 'leftSnmpService'
}

export enum ManageId {
  Network = 'leftNetworkConfig',
  Ntp = 'leftNtpConfig',
  Upgrade = 'leftUpgradeConfig',
  Update = 'leftUpdateConfig',
  Language = 'leftLanguageConfig',
  License = 'leftLicenseConfig',
  Ibma = 'leftIbmaConfig',
  Sp = 'leftSpConfig',
  USB = 'leftUSBConfig'
}

export enum SystemModel {
  SingleSystem = 'SingleSystem',
  DualSystem = 'DualSystem'
}

export enum VideoId {
  local = 'localId',
  cpu = 'cpuVideoId',
  off = 'offVideoId',
  rest = 'restVideoId'
}

export enum NavTheme {
  Top = 'top',
  TopLeft = 'topLeft',
  Left = 'left'
}

export enum ColorTheme {
  dark = 'dark',
  light = 'light'
}

export const enum PRODUCTTYPE {
  TIANCHI = 'tianchi',
  WUHAN = 'wuhan',
  ATLAS = 'atlas',
  COMMON = 'common'
}

/**
 * KVM cmdType定义，命名规则如下
 * xxx_REQ_C:客户端发起的请求信息
 * xxx_RSP_C:客户端发起的响应信息
 * xxx_REQ_S:服务端发起的请求信息
 * xxx_RSP_S:服务端发起的响应信息
 */
export enum CmdType {
  NEGOTIATE_VERSION_REQ_C = 0x0000,
  NEGOTIATE_VERSION_RSP_S = 0x0001,
  CONNECT_REQ_C = 0x0002,
  CONNECT_RSP_S = 0x0003,
  DISCONNECT_REQ_C = 0x0004,
  HEARTBEAT_REQ_C = 0x0006,

  IMAGE_DATA_REQ_S = 0x0100,
  GET_IMAGE_RESOLUTION_REQ_C = 0x0102,
  GET_IMAGE_RESOLUTION_RSP_S = 0x0103,
  SET_IMAGE_RESOLUTION_REQ_C = 0x0104,
  FORCE_I_FRAME_REQ_C = 0x0106,
  SCREEN_RECODING_START_REQ_C = 0x0108,
  SCREEN_RECODING_END_REQ_C = 0x010a,
  SCREEN_RECODING_END_REQ_D = 0x010c,
  SCREEN_RECODING_END_REQ_E = 0x010e,
  SCREEN_RECODING_END_REQ_F = 0x010f,

  KEYBOARD_STATUS_REQ_C = 0x0200,
  KEYBOARD_STATUS_RSP_S = 0x0201,
  KEYBOARD_DATA_REQ_C = 0x0202,
  MOUSE_INPUT_REQ_C = 0x0204,
  SET_MOUSE_MODE_REQ_C = 0x0206,
  GET_MOUSE_MODE_REQ_C = 0x0208,
  GET_MOUSE_MODE_RSP_S = 0x0209,
  RESET_USB_REQ_C = 0x0300,
  
  UMS_STATUS_REQ_C = 0x0302,
  UMS_STATUS_RSP_S = 0x0303,

  POWER_CONTROL_REQ_C = 0x0400,
  POWER_CONTROL_RSP_S = 0x0401,
  GET_BOOT_OPTION_REQ_C = 0x0402,
  GET_BOOT_OPTION_RSP_S = 0x0403,
  SET_BOOT_OPTION_REQ_C = 0x0404,
  SET_BOOT_OPTION_RSP_S = 0x0405,
  GET_BOOT_METHOD_REQ_C = 0x0406,
  GET_BOOT_METHOD_RSP_S = 0x0407,

  VMM_ENABLE_REQ_C = 0x0500,
  VMM_ENABLE_RSP_S = 0x0501,
  VMM_PORT_REQ_C = 0x0502,
  VMM_PORT_RSP_S = 0x0503,

  CUSTOM_DATA_GET_P = 0x020a,
  CUSTOM_DATA_GET_R = 0x020b,
  CUSTOM_DATA_SAVE_P = 0x020c,
  CUSTOM_DATA_SAVE_R = 0x020d,
  CUSTOM_DATA_DEL_P = 0x020e,
  CUSTOM_DATA_DEL_R = 0x020f,
}

// vmm的cmdType定义
export enum VmmCmdType {
  NEGOTIATE_VERSION = 0x00,
  ACK = 0x01,
  CONNECT = 0x02,
  CREATE_DEV = 0x03,
  TRAN_UFI = 0x04,
  TRAN_SFF = 0x05,
  DISCONNECT = 0x06,
  HEARTBEAT = 0x07,
  CLOSE_DEV = 0x08,
  UFI_OPT_END = 0x09,
  SFF_OPT_END = 0x0a
}

// video 的opCode
export enum VideoOpCode {
  CONNECT = 0x01,
  DISCONNECT = 0x02,
  HEARTBEAT = 0x03,
  PLAY_START = 0x04,
  PLAY_STOP = 0x05,
  PLAY_PAUSE = 0x06,
  PLAY_CONTINUE = 0x07,
  PLAY_SPEED = 0x08,
  PLAY_PROGRESS = 0x09,
}

export enum SeriesName {
  AVG = 0,
  PEAK = 1,
  WATTS = 2,
}
