//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IInfoCard {
  id: number;
  Name: string;
  firmwareVersion: string | null;
  inputWatts: number | null;
  lineInputVoltage: number | null;
  manufacturer: string | null;
  mode: string | null;
  model: string | null;
  name: string | null;
  outputVoltage: number | null;
  partNumber: string | null;
  powerCapacityWatts: number | null;
  powerSupplyChannel: string | null;
  powerSupplyType: string | null;
  serialNumber: string | null;
  state: string | null;
}

export interface IPowerSetting {
  workingMode: 'Sharing' | 'Active/Standby' | null;
  activePSU: IPSUList[];
  deepSleep: string;
  normalAndRedundancy: boolean | null;
}

export interface IPSUList {
  name: string;
  mode: string | null;
  isCommand: boolean;
}

export interface IPowerOnPolicy {
  id: string;
  label: string;
  disabled: boolean;
}

export interface IPowerOnDelayed {
  label: string;
  desc: string;
  disabled: boolean;
}

export interface IUnitSwitch {
  leftText: string;
  rightText: string;
  default: number;
}

export interface IPowerHistoryData {
  powerPeakWattsList: any[];
  powerAverageWattsList: any[];
  powerWattsList: any[];
  timeList: any[];
  timeListLen: number | null;
  start: string;
  end: string;
}

export interface IHistoryData {
  highPowerThresholdWatts: number | null;
  powerHistoryData: IPowerHistoryData;
  maxLimitInWatts: number | null;
  minLimitInWatts: number | null;
}

export interface IPowerCappingInfo {
  averageConsumedWatts: number | null;
  currentCPUPowerWatts: number | null;
  currentMemoryPowerWatts: number | null;
  maxConsumedOccurred: string;
  maxConsumedWatts: number | null;
  powerConsumedWatts: number | null;
  statisticsCollected: string;
  totalConsumedPowerkWh: number | null;
  powerLimit: IPowerLimit;
  powerCapMode: boolean | null;
  [propName: string]: any;
}

export interface IPowerLimit {
  limitException: string | boolean;
  limitInWatts: number | null;
  limitState: string;
  MSPPEnabled: number | null;
  maxLimitInWatts: number | null;
  minLimitInWatts: number | null;
  powerLimitExceptionSupported: boolean;
  powerLimitStatus: number | null;
  powerCappingSupported: boolean;
  powerLimitMode: string;
  powerLimitExceptionAllowableValues: string[];
}

export interface IVirtualKeyInfo {
  id: string;
  show: boolean;
  information: string;
  className?: string | null;
  promptMessage?: string | null;
  promptId?: string | null;
  helpTips?: string | null;
}

export interface ITabList {
  index: string;
  label: string;
  router: string;
  id: string;
}

export interface showDataT {
  label: string;
  value: string;
}