//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface ILabelValue {
  label: string;
  value?: string | number | null;
  [propName: string]: any;
}

// 字段配置
export interface IFields {
  key: string;
  lable: string;
  unit?: string;
  judgments?: Array<string>;
  fun?: any;
  [propName: string]: any;
}

// 任意{}
export interface IAny {
  [propName: string]: any;
}

interface IRelatedProcessorPort {
  ProcessorSilkText: string;
  PortId: string;
  IODDieId: number;
}

// 表格数据
export interface IBasicAttribute {
  PhysicalPortNumber?: string | number;
  MediaType?: string;

  FC_ID?: string | number | null;
  InterfaceType?: string | null;
  LinkStatus?: string | null;
  Name?: string | number | null;
  RelatedProcessorPorts?: IRelatedProcessorPort[];
  extendData?: INetDataPortProperties;
  [propName: string]: any;
}

// ipv4
export interface IIpv4 {
  Address?: string | number | null;
  Gateway?: string | number | null;
  Mask?: string | number | null;
  [propName: string]: any;
}

// ipv6
export interface IIpv6 {
  Address?: string | number | null;
  Gateway?: string | number | null;
  Mask?: string | number | null;
  [propName: string]: any;
}

// 表格展开数据
export interface INetworkAttribute {
  MAC?: string | null;
  Name?: string | null;
  LinkStatus?: string | null;
  IPv4Addresses?: Array<IIpv4>;
  IPv6Addresses?: Array<IIpv6>;

  DriverName?: string | null;
  DriverVersion?: string | null;
  FirmwareVersion?: string | null;
  LinkSpeedGbps?: string | number | null;
  PortStatus?: string | null;
  RXRateGbps?: string | number | null;
  RateNegotiationStage?: string | null;
  RxBbCredit?: string | number | null;
  TXRateGbps?: string | number | null;
  TxBbCredit?: string | number | null;
  WWNN?: string | null;
  WWPN?: string | null;
  WorkingRate?: string | number | null;
  [propName: string]: any;
}

export interface ILaneMappings {
  LaneId: number;
  RelatedTransceiverLane: {
    TransceiverLaneId: number;
    TransceiverSilkText: string;
  };
}

// 单张卡的展示数据 - 表格数据 和 下拉数据
export interface INetDataPortProperties {
  BasicAttribute?: IBasicAttribute;
  NetworkAttribute?: INetworkAttribute;
  LinkView?: ILinkView;
  DCB?: IDcb;
  OpticalModule?: IOpticalModule;
  Statistics?: IStatistics;
  LaneMappings?: ILaneMappings[];
  [propName: string]: any;
}

// 单张卡的展示数据
export interface ICartData {
  CardManufacturer?: string;
  CardModel?: string;
  CardName?: string;
  ChipManufacturer?: string;
  ChipModel?: string;
  DisplayName?: string;
  PartNumber?: string;
  SerialNumber?: string;
  PortProperties?: Array<INetDataPortProperties>;
  [propName: string]: any;
}

// 表格column
export interface IColumns {
  title: string;
  key: string;
  state?: boolean;
  [propName: string]: any;
}

export interface ILinkView {
  SwitchName?: string | null | number;
  SwitchConnectionID?: string | null | number;
  SwitchPortID?: string | null | number;
  SwitchVLANID?: string | null | number;
  [propName: string]: any;
}

// DCB - 加工后的数据的子项
export interface IDcbItem {
  label: string;
  value?: string | number | null | Array<string | number>;
  [propName: string]: any;
}

// DCB
export interface IDcb {
  PGPCT?: string | number | Array<string | number>;
  Pfcup: string | number | Array<string | number>;
  PgStrict: string | number | Array<string | number>;
  Pgid: string | number | Array<string | number>;
  Up2cos: string | number | Array<string | number>;
  [propName: string]: any;
}

// 光模块
export interface IOpticalModule {
  ConnectorType?: string | null;
  DeviceType?: string | null;
  Indentifier?: string | null;
  Manufacturer?: string | null;
  PartNumber?: string | null;
  RXPower?: Array<IRXPowerTXPower>;
  RxLosState?: string | number;
  SerialNumber?: string | null;
  SupportedSpeedsMbps?: Array<any> | string | null;
  TXBiasCurrent?: Array<ITXBiasCurrent>;
  TXPower?: Array<IRXPowerTXPower>;
  Temperature?: ITemperature;
  TransceiverType?: string | null;
  TxFaultState?: string | number;
  Voltage?: IVoltage;
  WaveLengthNanometer?: string | null;
  [propName: string]: any;
}

// RXPower 和 TXPower
export interface IRXPowerTXPower {
  LowerThresholdCritical?: number | null | string;
  ReadingMilliWatts?: number | null;
  UpperThresholdCritical?: number | null | string;
  [propName: string]: any;
}

// TXBiasCurrent
export interface ITXBiasCurrent {
  LowerThresholdCritical?: number | null | string;
  ReadingMilliAmperes?: number | null;
  UpperThresholdCritical?: number | null | string;
  [propName: string]: any;
}

// Temperature
export interface ITemperature {
  LowerThresholdCritical?: number | null | string;
  ReadingCelsius?: number | null;
  UpperThresholdCritical?: number | null | string;
  [propName: string]: any;
}

// Voltage
export interface IVoltage {
  LowerThresholdCritical?: number | null | string;
  ReadingVolts?: number | null;
  UpperThresholdCritical?: number | null | string;
  [propName: string]: any;
}

// 统计信息：以太网
export interface IStatistics {
  Received?: IStatisticsReceived;
  Transmitted?: IStatisticsTransmitted;
  [propName: string]: any;
}

// 统计信息：以太网 - 接收统计信息
export interface IStatisticsReceived {
  BroadcastPacketsReceived?: string;
  FcsReceiveErrors?: string;
  JabberPacketsReceived?: string;
  MulticastPacketsReceived?: string;
  TotalBytesReceived?: string;
  UnicastPacketsReceived?: string;
  [propName: string]: any;
}

// 统计信息：以太网 - 发送统计信息
export interface IStatisticsTransmitted {
  BroadcastPacketsTransmitted?: string;
  MulticastPacketsTransmitted?: string;
  TotalBytesTransmitted?: string;
  UnicastPacketsTransmitted?: string;
  [propName: string]: any;
}

// 所有卡的 数据格式
export interface INetData {
  type: 'root';
  key: string;
  name: string;
  children: Array<IPerCartData>;
  [propName: string]: any;
}

// 单张卡的 数据
export interface IPerCartData {
  type: 'leaf';
  key: string;
  name: string;
  showData: ICartData;
  [propName: string]: any;
}
