//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface Imonitor {
  BMARunningStatus: boolean;
  cpuUsagePercent?: string | number;
  cpuThresholdPercent: number;
  editorCPUThresholdPercent?: string | number;
  memoryUsagePercent?: string | number | null;
  memoryThresholdPercent: number;
  editorMemoryThresholdPercent?: string | number;
  totalSystemMemoryGiB: number;
  systemMemoryCachedGiB: number;
  systemMemoryFreeGiB: number;
  systemMemoryBuffersGiB: number;
  networkTypeList: INetworkChartData[];
  networkType: INetworkChartData;
  netBandwidthThresholdPercent: number;
  editorNetBandwidthThresholdPercent?: string | number;
  diskInfoLists: IDiskCharts[];
  hardDiskThresholdPercent: number;
  editorHardDiskThresholdPercent?: string | number;
}

export interface IMoitorThresholdPercent {
  tip?: string;
  loading: boolean;
  [propName: string]: any;
}

export interface IChartsData {
  UsagePercent?: number | string;
  ThresholdPercent?: number | string;
  editThresholdPercent?: string;
  History?: any;
  systemId?: number;
  [propName: string]: any;
}

export interface INetworkChartData {
  BWUWaveTitle: string;
  CurrentUtilisePercents: any[];
  showLineState: boolean[];
  PortCount: number;
  UtilisePercents: INetworkChart[];
}

export interface INetworkChart {
  Time: string;
  UtilisePercent: number[];
}

export interface IDiskCharts {
  PartitionName: string;
  UsedGB: number;
  CapacityGB: number;
  [propName: string]: any;
}