//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

export interface KVMData {
  autoCloseLocalDisplay: boolean;
  encryptionConfigurable: boolean;
  encryptionEnabled: boolean;
  graphicalConsole: GraphicalConsoleItem[];
  localKvmEnabled: boolean;
  sessionTimeoutMinutes: number | null;
  visibleJavaKvm: boolean;
}

export interface GraphicalConsoleItem {
  systemId: number | string;
  port: number | null;
  enabled: boolean | null;
  activatedSessionsType: string | null;
  persistentUSBConnectionEnabled: boolean | null;
  autoOSLockEnabled: boolean | null;
  autoOSLockType: string | null;
  autoOSLockKey: string[];
  disableKeyboardDuringBiosStartup: boolean | null;
  maximumNumberOfSessions: number | null;
  numberOfActiveSessions: number | null;
}

export interface PopoverState {
  [key: string]: boolean;
}