//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { forbidGuard } from '@/apps/app-bmc/guard/forbid.guard';
import { storageGuard } from '@/apps/app-bmc/guard/storage.guard';
import { RouteRecordRaw } from 'vue-router';
import infoRoutes from './info/info-router';
import biosRoutes from './bios/bios-router';
import powerRoutes from './power/power-router';
import fansRoutes from './fans/fans-router';
import { fansGuard, partityGuard, biosGuard, infoGuard } from '@/apps/app-bmc/guard';

const systemRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/system/info',
    component: () => import('@/pages/System/Info/Info.vue'),
    redirect: '/navigate/system/info/product',
    children: infoRoutes,
    beforeEnter: infoGuard,
  },
  {
    path: '/navigate/system/monitor',
    component: () => import('@/pages/System/Monitor/Monitor.vue'),
  },
  {
    path: '/navigate/system/storage',
    component: () => import('@/pages/System/Storage/Storage.vue'),
    beforeEnter: storageGuard,
  },
  {
    path: '/navigate/system/power',
    component: () => import('@/pages/System/Power/Power.vue'),
    children: powerRoutes,
  },
  {
    path: '/navigate/system/fans',
    component: () => import('@/pages/System/Fans/Fans.vue'),
    children: fansRoutes,
    beforeEnter: fansGuard,
  },
  {
    path: '/navigate/system/bios-settings',
    component: () => import('@/pages/System/BiosConfig/BiosConfig.vue'),
    redirect: '/navigate/system/bios-settings/bios',
    children: biosRoutes,
    beforeEnter: biosGuard,
  },
  {
    path: '/navigate/system/fusion-par',
    component: () => import('@/pages/System/Partity/Partity.vue'),
    beforeEnter: partityGuard,
  },
];
export default systemRoutes;
