//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import HomeComponent from '../../Navigate/Home/Home.vue';
import SystemComponent from '../../Navigate/System/System.vue';
import ServiceComponent from '../../Navigate/Service/Service.vue';
import MaintanceComponent from '../../Navigate/Maintance/Maintance.vue';
import UserComponent from '../../Navigate/User/User.vue';
import ManagerComponent from '../../Navigate/Manager/Manager.vue';
import systemRoutes from './system/system-router';
import serviceRoutes from './service/service-router';
import userRouters from './user/user-router';
import maintanceRouters from './maintance/maintance-router';
import managerRouters from './manager/manager-router';

const navRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/home',
    component: HomeComponent,
  },
  {
    // 系统管理
    path: '/navigate/system',
    component: SystemComponent,
    redirect: '/navigate/system/info',
    children: systemRoutes,
  },
  {
    path: '/navigate/maintenance',
    component: MaintanceComponent,
    redirect: '/navigate/maintenance/alarm',
    children: maintanceRouters,
  },
  {
    path: '/navigate/user',
    component: UserComponent,
    redirect: '/navigate/user/local-users',
    children: userRouters,
  },
  {
    path: '/navigate/service',
    component: ServiceComponent,
    children: serviceRoutes,
  },
  {
    path: '/navigate/manager',
    component: ManagerComponent,
    redirect: '/navigate/manager/network',
    children: managerRouters,
  },
];
export default navRoutes;
