//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import { kvmMultiGuard } from '@/apps/app-bmc/guard/kvmMulti.guard';

const reportRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/maintenance/report/syslog',
    component: () => import('@/pages/Maintance/Report/component/Syslog.vue'),
  },
  {
    path: '/navigate/maintenance/report/syslogdb',
    component: () => import('@/pages/Maintance/Report/component/SyslogDB.vue'),
  },
  {
    path: '/navigate/maintenance/report/email',
    component: () => import('@/pages/Maintance/Report/component/Email.vue'),
  },
  {
    path: '/navigate/maintenance/report/trap',
    component: () => import('@/pages/Maintance/Report/component/Trap.vue'),
    beforeEnter: [kvmMultiGuard],
  },
];
export default reportRoutes;
