//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { forbidGuard } from '@/apps/app-bmc/guard/forbid.guard';
import { fdmGuard } from '@/apps/app-bmc/guard';
import { reportGuard } from '@/apps/app-bmc/guard/report.guard';
import { RouteRecordRaw } from 'vue-router';
import ibmcRoutes from './ibmc/ibmc-router';
import assetRoutes from './asset/asset-router';
import reportRoutes from './report/report-router';
import { kvmMultiGuard } from '@/apps/app-bmc/guard/kvmMulti.guard';
import { telemetryGuard } from '@/apps/app-bmc/guard/telemetry.guard';

const managerRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/maintenance/alarm',
    component: () => import('@/pages/Maintance/AlarmEvent/AlarmEvent.vue'),
  },
  {
    path: '/navigate/maintenance/report',
    component: () => import('@/pages/Maintance/Report/Report.vue'),
    redirect: '/navigate/maintenance/report/syslog',
    children: reportRoutes,
    beforeEnter: [reportGuard],
  },
  {
    path: '/navigate/maintenance/video',
    component: () => import('@/pages/Maintance/Video/Video.vue'),
    beforeEnter: [kvmMultiGuard],
  },
  {
    path: '/navigate/maintenance/diagnostics',
    component: () => import('@/pages/Maintance/Systemlog/Systemlog.vue'),
  },
  {
    path: '/navigate/maintenance/bmc-logs',
    component: () => import('@/pages/Maintance/Ibmclog.vue'),
    redirect: '/navigate/maintenance/bmc-logs/operation',
    children: ibmcRoutes,
  },
  {
    path: '/navigate/maintenance/work-records',
    component: () => import('@/pages/Maintance/Worknote/Worknote.vue'),
  },
  {
    path: '/navigate/maintenance/asset-maintance',
    component: () => import('@/pages/Maintance/AssetMaintance/AssetMaintance.vue'),
    redirect: '/navigate/maintenance/asset-maintance/asset-inventory',
    children: assetRoutes,
  },
  {
    path: '/navigate/maintenance/telemetry-data',
    component: () => import('@/pages/Maintance/Telemetry/Telemetry.vue'),
    beforeEnter: [telemetryGuard],
  },
  {
    path: '',
    redirect: '/navigate/maintenance/alarm',
  },
];
export default managerRoutes;
