//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export default {
  LdapGroup: {
    ldapGoupCnt: 5,
    Members: [
      {
        Domain: 'CN=r1,OU=,DC=',
        ID: 0,
        Name: 'r1',
        Folder: '',
        LoginInterface: ['Web', 'SSH', 'Redfish'],
        LoginRule: ['Rule1', 'Rule3'],
        RoleID: 'Common User'
      },
      {
        Domain: 'CN=2s,OU=CN=xxx,OU=xxx,DC=',
        ID: 1,
        Name: '2s',
        Folder: 'CN=xxx,OU=xxx',
        LoginInterface: ['Web', 'SSH'],
        LoginRule: ['Rule3'],
        RoleID: 'Administrator'
      },
      {
        Domain: 'CN=s3,OU=,DC=',
        ID: 2,
        Name: 's3',
        Folder: '',
        LoginInterface: ['Web', 'SSH', 'Redfish'],
        LoginRule: [],
        RoleID: 'Custom Role 1'
      },
      {
        Domain: 'CN=,OU=,DC=',
        ID: 3,
        Name: '',
        Folder: '',
        LoginInterface: ['Web', 'SSH', 'Redfish'],
        LoginRule: [],
        RoleID: 'Custom Role 4'
      },
      {
        Domain: 'CN=,OU=,DC=',
        ID: 4,
        Name: '',
        Folder: '',
        LoginInterface: ['Web', 'SSH', 'Redfish'],
        LoginRule: [],
        RoleID: 'Custom Role 4'
      }
    ]
  },
  ControllerCnt: 6,
  Controller: {
    Domain: 'neil.com.hauwei',
    Port: 634,
    Folder:
      'CN=aaaaaaabbbbbbbbbbaaaaaaaaaabbbbbbbbbbaaaaaaaaaabbbbbbbbbbxxx,CN=aaaaaaaaaabbbbbbbbbbaaaaaaaaaabbbbbbbbbbaaaaaaaaaabbbbbbbbbbxxx',
    IPAddress: '1.1.1.1',
    BindDN: 'abcde'
  },
  Certificate: {
    VerificationLevel: 'Demand',
    IntermediateCert: [
      {
        Issuer: 'CN=000, OU=, O=, L=, S=, C=',
        ValidNotBefore: 'Apr 28 2018 UTC',
        ValidNotAfter: 'May 25 2028 UTC',
        Subject: 'CN=000, OU=, O=, L=, S=, C=',
        SerialNumber: '01'
      }
    ],
    CrlVerification: true,
    CRLValidNotBefore: '',
    CRLValidNotAfter: '',
    ServerCert: {
      Issuer: 'CN=000, OU=, O=, L=, S=, C=',
      ValidNotBefore: 'Apr 28 2018 UTC',
      ValidNotAfter: 'May 25 2028 UTC',
      Subject: 'CN=001, OU=, O=, L=, S=, C=',
      SerialNumber: '02'
    },
    VerificationEnabled: true,
    RootCert: {
      Issuer: 'CN=000, OU=, O=, L=, S=, C=',
      ValidNotBefore: 'Apr 28 2018 UTC',
      ValidNotAfter: 'May 25 2028 UTC',
      Subject: 'CN=000, OU=, O=, L=, S=, C=',
      SerialNumber: '01'
    }
  }
};
