//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import Date from '../../../../src/utils/date';
const powerData = {
  HighPowerThresholdWatts: 250,
  History: [],
  Metrics: [
    {
      AverageConsumedWatts: 247,
      CurrentCPUPowerWatts: 125,
      CurrentMemoryPowerWatts: 3,
      MaxConsumedOccurred: '2021-10-23T14:28:49-12:00',
      MaxConsumedWatts: 444,
      PowerConsumedWatts: 228,
      StatisticsCollected: '2021-09-27T12:16:06-12:00',
      TotalConsumedPowerkWh: 590.65977388889
    }
  ],
  PowerLimit: {
    LimitException: 'NoAction',
    LimitInWatts: 1000,
    LimitState: 'On',
    MSPPEnabled: null,
    MaxLimitInWatts: 1100,
    MinLimitInWatts: 279,
    PowerLimitExceptionSupported: true,
    PowerLimitStatus: null
  }
};
const powerHistory: object[] = [];
// 生成随机数据
const dataMake = () => {
  const startTime = '2022/01/01 00:00:00';
  let time = new Date(startTime).getTime();
  for (let i = 0; i < 3000; i++) {
    time = time + 600 * 1000;
    const Time = new Date(time).pattern('yyyy/MM/dd HH:mm');
    const obj = {
      'PowerAverageWatts|100-290':100,
      'PowerPeakWatts|110-300':100,
      'PowerWatts|100-300':100,
      Time: Time
    };
    powerHistory.push(obj);
  }
};
dataMake();
(powerData.History as Object[]) = powerHistory;
export default powerData;
