//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const fdmData = {
  DeviceTree: [
    {
      EventReports: '/UI/Rest/Maintenance/FDM/65537/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/Cpu1',
      SilkName: 'CPU1',
      ComponentType: 'CPU',
      ComponentID: 0,
      HealthStatus: 'Good',
      OnlineTimeStamp: 1620265269,
      OnlineTimeZone: -720,
      AssociateDevice: [
        {
          EventReports: '/UI/Rest/Maintenance/FDM/69632/EventReports',
          DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/ComMotherBoard',
          SilkName: 'Mainboard',
          ComponentType: 'Mainboard',
          ComponentID: 16,
          HealthStatus: 'Good',
          OnlineTimeStamp: 1620265269,
          OnlineTimeZone: -720,
          AssociateDevice: [
            {
              EventReports: '/UI/Rest/Maintenance/FDM/65793/EventReports',
              DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/Memory000',
              SilkName: 'DIMM000',
              ComponentType: 'Memory',
              ComponentID: 1,
              HealthStatus: 'Good',
              OnlineTimeStamp: 1620352307,
              OnlineTimeZone: -720,
              AssociateDevice: [],
              Alias: 65793
            },
            {
              EventReports: '/UI/Rest/Maintenance/FDM/68864/EventReports',
              DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/LomCard',
              SilkName: 'LOM',
              ComponentType: 'NIC',
              ComponentID: 13,
              HealthStatus: 'Good',
              OnlineTimeStamp: 1644570626,
              OnlineTimeZone: -720,
              AssociateDevice: [],
              Alias: 68864
            },
            {
              EventReports: '/UI/Rest/Maintenance/FDM/67073/EventReports',
              DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/Raid-1',
              SilkName: 'RAID Card1',
              ComponentType: 'RAID Card',
              ComponentID: 6,
              HealthStatus: 'Good',
              OnlineTimeStamp: 1644570626,
              OnlineTimeZone: -720,
              AssociateDevice: [
                {
                  EventReports: '/UI/Rest/Maintenance/FDM/66817/EventReports',
                  DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/HDDBackplane-2',
                  SilkName: 'Disk BP1',
                  ComponentType: 'Disk Backplane',
                  ComponentID: 5,
                  HealthStatus: 'Good',
                  OnlineTimeStamp: 1644570626,
                  OnlineTimeZone: -720,
                  AssociateDevice: [
                    {
                      EventReports: '/UI/Rest/Maintenance/FDM/66049/EventReports',
                      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/Hdd1-2',
                      SilkName: 'Disk1',
                      ComponentType: 'Disk',
                      ComponentID: 2,
                      HealthStatus: 'Good',
                      OnlineTimeStamp: 1639725505,
                      OnlineTimeZone: -720,
                      AssociateDevice: [],
                      Alias: 66049
                    },
                    {
                      EventReports: '/UI/Rest/Maintenance/FDM/66050/EventReports',
                      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/Hdd2-2',
                      SilkName: 'Disk2',
                      ComponentType: 'Disk',
                      ComponentID: 2,
                      HealthStatus: 'Good',
                      OnlineTimeStamp: 1639725505,
                      OnlineTimeZone: -720,
                      AssociateDevice: [],
                      Alias: 66050
                    }
                  ],
                  Alias: 66817
                }
              ],
              Alias: 67073
            }
          ],
          Alias: 69632
        }
      ],
      Alias: 65537
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/65538/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/Cpu2',
      SilkName: 'CPU2',
      ComponentType: 'CPU',
      ComponentID: 0,
      HealthStatus: 'Good',
      OnlineTimeStamp: 1620265269,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 65538
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/66305/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/onepower-4',
      SilkName: 'PSU1',
      ComponentType: 'PSU',
      ComponentID: 3,
      HealthStatus: 'Good',
      OnlineTimeStamp: 1644396119,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 66305
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/66306/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/onepower-5',
      SilkName: 'PSU2',
      ComponentType: 'PSU',
      ComponentID: 3,
      HealthStatus: 'Good',
      OnlineTimeStamp: 1644570627,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 66306
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/66561/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/fan1',
      SilkName: 'Fan1',
      ComponentType: 'Fan',
      ComponentID: 4,
      HealthStatus: 'Failed',
      OnlineTimeStamp: 1644570625,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 66561
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/66562/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/fan2',
      SilkName: 'Fan2',
      ComponentType: 'Fan',
      ComponentID: 4,
      HealthStatus: 'Failed',
      OnlineTimeStamp: 1644570625,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 66562
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/66563/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/fan3',
      SilkName: 'Fan3',
      ComponentType: 'Fan',
      ComponentID: 4,
      HealthStatus: 'Failed',
      OnlineTimeStamp: 1644570625,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 66563
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/66564/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/fan4',
      SilkName: 'Fan4',
      ComponentType: 'Fan',
      ComponentID: 4,
      HealthStatus: 'Failed',
      OnlineTimeStamp: 1644570626,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 66564
    },
    {
      EventReports: '/UI/Rest/Maintenance/FDM/70145/EventReports',
      DeviceInfo: '/UI/Rest/Maintenance/FDM/Device/ComChassis',
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      HealthStatus: 'Degraded',
      OnlineTimeStamp: 1620265270,
      OnlineTimeZone: -720,
      AssociateDevice: [],
      Alias: 70145
    }
  ]
};

export const cpu1Data = {
  PartNumber: '41020623',
  Model: 'Intel(R) Xeon(R) Gold 6138T CPU @ 2.00GHz',
  OtherParameters:
    '64-bit Capable| Multi-Core| Hardware Thread| Execute Protection| Enhanced Virtualization| Power/Performance Control',
  FrequencyMHz: 2000,
  DeviceName: 'CPU1',
  TotalCores: 20,
  State: 'Enabled',
  TotalThreads: 40,
  SerialNumber: '29F564E82497D080',
  L1CacheKiB: 1280,
  IdentificationRegisters: '54-06-05-00-FF-FB-EB-BF',
  L2CacheKiB: 20480,
  Manufacturer: 'Intel(R) Corporation',
  L3CacheKiB: 28160
};

export const comMotherBoardData = {
  PMEVersion: '8.90(U4282)',
  UbootVersion: '5.3.04 (Oct 15 2021 - 10:29:19)',
  PchModel: 'LBG QS/PRQ - 2 - S1',
  UbootBackupVer: '5.3.04 (Oct 15 2021 - 10:29:19)',
  PCBVersion: '.C',
  BoardId: '0x0017',
  BoardModel: 'CH80G2500889',
  DeviceType: 'MainBoard',
  CPLDVersion: '2.09(U4269)',
  BiosVersion: '7.66(U47)',
  Manufacturer: 'Huawei',
  SerialNumber: 'abc',
  PartNumber: '777777777777777'
};

export const memory000Data = {
  OperatingSpeedMhz: 2133,
  CapacityMiB: 16384,
  DeviceName: 'DIMM000',
  Position: 'mainboard',
  MinVoltageMillivolt: 1200,
  MemoryDeviceType: 'DDR4',
  DataWidthBits: 72,
  Technology: 'DRAM',
  RankCount: 2,
  Manufacturer: 'Hynix',
  SerialNumber: '316C9F3C',
  PartNumber: 'HMA42GR7MFR4N-TF'
};

export const lomCardData = {
  Model: 'X722',
  CardManufacturer: 'Huawei',
  PCBVersion: '.C',
  CardModel: '2*10GE+2*GE',
  Manufacturer: 'Intel',
  BoardId: '0x0017',
  Name: 'LOM'
};

export const Raid1Data = {
  PCBVersion: '.C',
  BoardId: '0x001a',
  Location: 'mainboard',
  CardNo: 1,
  Description: 'LSI SAS3416',
  SupportedRAIDLevels: 'RAID(0/1/10)',
  AssociatedResource: 'CPU1',
  Manufacturer: 'Huawei',
  ProductName: 'RAID-M',
};

export const HDDBackplane2Data = {
  CardNo: 1,
  Manufacturer: 'Huawei',
  PCBVersion: '.A',
  Description: '12*3.5 SAS/SATA, Expander',
  CPLDVersion: '1.11',
  BoardId: '0x0073',
  Location: 'chassisFront'
};

export const hdd12Data = {
  Model: null,
  IndicatorLED: 'Off',
  AssociatedResource: null,
  Protocol: 'SATA/SAS',
  SASAddress: [null, null],
  Revision: null,
  TemperatureCelsius: null,
  CapacityBytes: null,
  HotspareType: null,
  PartNum: null,
  RebuildState: 'DoneOrNotRebuilt',
  PatrolState: 'DoneOrNotPatrolled',
  PredictedMediaLifeLeftPercent: null,
  Manufacturer: null,
  SerialNumber: null,
  HoursOfPoweredUp: null
};

export const hdd22Data = {
  Model: null,
  IndicatorLED: 'Off',
  AssociatedResource: null,
  Protocol: 'SATA/SAS',
  SASAddress: [null, null],
  Revision: null,
  TemperatureCelsius: null,
  CapacityBytes: null,
  HotspareType: null,
  PartNum: null,
  RebuildState: 'DoneOrNotRebuilt',
  PatrolState: 'DoneOrNotPatrolled',
  PredictedMediaLifeLeftPercent: null,
  Manufacturer: null,
  SerialNumber: null,
  HoursOfPoweredUp: null
};

export const cpu2Data = {
  Model: 'Intel(R) Xeon(R) Gold 6138T CPU @ 2.00GHz',
  L2CacheKiB: 20480,
  DeviceName: 'CPU2',
  L3CacheKiB: 28160,
  L1CacheKiB: 1280,
  OtherParameters:
    '64-bit Capable| Multi-Core| Hardware Thread| Execute Protection| Enhanced Virtualization| Power/Performance Control',
  Manufacturer: 'Intel(R) Corporation',
  FrequencyMHz: 2000,
  IdentificationRegisters: '54-06-05-00-FF-FB-EB-BF',
  TotalCores: 20,
  State: 'Enabled',
  TotalThreads: 40,
  SerialNumber: '29F529AD5C5BA684',
  PartNumber: '41020623'
};

export const onepower4Data = {
  Model: 'PS-2551-4H',
  MemberId: 0,
  FirmwareVersion: 'DC:109 PFC:106',
  PowerCapacityWatts: 550,
  PartNumber: '99011VLF',
  Manufacturer: 'LITEON',
  SerialNumber: '2199011VLFCSJ7038330',
  PowerSupplyType: 'AC'
};

export const onepower5Data = {
  Model: 'PS-2551-4H',
  MemberId: 1,
  FirmwareVersion: 'DC:109 PFC:106',
  PowerCapacityWatts: 550,
  PartNumber: '99011VLF',
  Manufacturer: 'LITEON',
  SerialNumber: '2199011VLFCSJ8012512',
  PowerSupplyType: 'AC'
};

export const fan1Data = {
  Model: '02311VSF 8038+',
  Speed: '9960',
  SpeedRatio: '0',
  Name: 'Fan1',
  PartNumber: '02311VSF'
};

export const fan2Data = {
  Model: '02311VSF 8038+',
  Speed: '9960',
  SpeedRatio: '0',
  Name: 'Fan2',
  PartNumber: '02311VSF'
};
export const fan3Data = {
  Model: '02311VSF 8038+',
  Speed: '9840',
  SpeedRatio: '0',
  Name: 'Fan3',
  PartNumber: '02311VSF'
};

export const fan4Data = {
  Model: '02311VSF 8038+',
  Speed: '9960',
  SpeedRatio: '0',
  Name: 'Fan4',
  PartNumber: '02311VSF'
};

export const comChassisData = [];

export const eventReports65537Data = {
  EventRecords: [
    {
      SN: 'UNKNOWN',
      Level: 'Event',
      Information: 'Device Installation(PPIN: UNKNOWN).',
      ReportTimeStamp: 1645062152,
      ComponentType: 'CPU',
      SilkName: 'CPU1',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 0,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports69632Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: abc).',
      ReportTimeStamp: 1620265269,
      ComponentType: 'Mainboard',
      SilkName: 'Mainboard',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 16,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports65793Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: UNKNOWN).',
      ReportTimeStamp: 1644910250,
      ComponentType: 'Memory',
      SilkName: 'DIMM000',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 1,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports68864Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation.',
      ReportTimeStamp: 1644910251,
      ComponentType: 'NIC',
      SilkName: 'LOM',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 13,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports67073Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: UNKNOWN).',
      ReportTimeStamp: 1644910252,
      ComponentType: 'RAID Card',
      SilkName: 'RAID Card1',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 6,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66817Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation.',
      ReportTimeStamp: 1644910252,
      ComponentType: 'Disk Backplane',
      SilkName: 'Disk BP1',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 5,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66049Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: UNKNOWN).',
      ReportTimeStamp: 1644910252,
      ComponentType: 'Disk',
      SilkName: 'Disk1',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 2,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66050Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: UNKNOWN).',
      ReportTimeStamp: 1644910252,
      ComponentType: 'Disk',
      SilkName: 'Disk2',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 2,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports65538Data = {
  EventRecords: [
    {
      SN: 'UNKNOWN',
      Level: 'Event',
      Information: 'Device Installation(PPIN: UNKNOWN).',
      ReportTimeStamp: 1644910250,
      ComponentType: 'CPU',
      SilkName: 'CPU2',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 0,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66305Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: 2199011VLFCSJ7038330).',
      ReportTimeStamp: 1644396119,
      ComponentType: 'PSU',
      SilkName: 'PSU1',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 3,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66306Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation(SN: 2199011VLFCSJ8012512).',
      ReportTimeStamp: 1644910252,
      ComponentType: 'PSU',
      SilkName: 'PSU2',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 3,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66561Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation.',
      ReportTimeStamp: 1644910251,
      ComponentType: 'Fan',
      SilkName: 'Fan1',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 4,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};
export const eventReports66562Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation.',
      ReportTimeStamp: 1644910251,
      ComponentType: 'Fan',
      SilkName: 'Fan2',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 4,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66563Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation.',
      ReportTimeStamp: 1644910251,
      ComponentType: 'Fan',
      SilkName: 'Fan3',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 4,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports66564Data = {
  EventRecords: [
    {
      Level: 'Event',
      Information: 'Device Installation.',
      ReportTimeStamp: 1644910251,
      ComponentType: 'Fan',
      SilkName: 'Fan4',
      EventCodeStr: 'INSTALL_COMPONENT',
      ComponentID: 4,
      ReportTimeZone: -720,
      Type: 'Installation'
    }
  ]
};

export const eventReports70145Data = {
  EventRecords: [
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    },
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    },
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    },
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    },
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    },
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    },
    {
      ReportTimeStamp: 1628880886,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Critical',
      Information:
        'Deassert: The air inlet temperature (28.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628815763,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Assert: The air inlet temperature (80.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628732529,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Major',
      Information:
        'Deassert: The air inlet temperature (27.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1628625490,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      Level: 'Minor',
      Information:
        'Assert: The air inlet temperature (51.000 degrees C) exceeds the overtemperature threshold (48.000 degrees C).',
      Type: 'SEL Warning',
      EventCodeStr: 'SEL'
    },
    {
      ReportTimeStamp: 1620265270,
      ReportTimeZone: -720,
      SilkName: 'Chassis',
      ComponentType: 'Chassis',
      ComponentID: 18,
      SN: '',
      Level: 'Event',
      EventCodeStr: 'INSTALL_COMPONENT',
      Type: 'Installation',
      Information: 'Device Installation(SN: ).'
    }
  ]
};
